/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class<?>[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T invokeConstructor(Class<T> klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = ConstructorUtils.toArray(arg);
        return ConstructorUtils.invokeConstructor(klass, args);
    }

    public static <T> T invokeConstructor(Class<T> klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ConstructorUtils.invokeConstructor(klass, args, parameterTypes);
    }

    public static <T> T invokeConstructor(Class<T> klass, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> ctor;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((ctor = ConstructorUtils.getMatchingAccessibleConstructor(klass, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = ConstructorUtils.toArray(arg);
        return ConstructorUtils.invokeExactConstructor(klass, args);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ConstructorUtils.invokeExactConstructor(klass, args, parameterTypes);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> ctor;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((ctor = ConstructorUtils.getAccessibleConstructor(klass, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> klass, Class<?> parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return ConstructorUtils.getAccessibleConstructor(klass, parameterTypes);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> klass, Class<?>[] parameterTypes) {
        try {
            return ConstructorUtils.getAccessibleConstructor(klass.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        if (ctor == null) {
            return null;
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            return null;
        }
        Class<T> clazz = ctor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return ctor;
        }
        return null;
    }

    private static Object[] toArray(Object arg) {
        Object[] args = null;
        if (arg != null) {
            args = new Object[]{arg};
        }
        return args;
    }

    /*
     * Unable to fully structure code
     */
    private static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
        try {
            ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException v0) {}
            return ctor;
        }
        catch (NoSuchMethodException v1) {
            paramSize = parameterTypes.length;
            var7_5 = ctors = clazz.getConstructors();
            var6_6 = ctors.length;
            var5_7 = 0;
            ** while (var5_7 < var6_6)
        }
lbl-1000:
        // 1 sources

        {
            ctor2 = var7_5[var5_7];
            ctorParams = ctor2.getParameterTypes();
            ctorParamSize = ctorParams.length;
            if (ctorParamSize == paramSize) {
                match = true;
                n = 0;
                while (n < ctorParamSize) {
                    if (!MethodUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (ctor = ConstructorUtils.getAccessibleConstructor(ctor2)) != null) {
                    try {
                        ctor.setAccessible(true);
                    }
                    catch (SecurityException v2) {}
                    typedCtor = ctor;
                    return typedCtor;
                }
            }
            ++var5_7;
            continue;
        }
lbl35:
        // 1 sources

        return null;
    }
}

