/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public abstract class AbstractPropertiesFactory<T extends Properties> {
    protected AbstractPropertiesFactory() {
    }

    protected abstract T createProperties();

    public T load(ClassLoader classLoader, String name) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream inputStream = classLoader.getResourceAsStream(name);){
            return this.load(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public T load(File file) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            return this.load(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public T load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        T properties = this.createProperties();
        ((Properties)properties).load(inputStream);
        return properties;
    }

    public T load(Path path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            return this.load(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public T load(Reader reader) throws IOException {
        T properties = this.createProperties();
        ((Properties)properties).load(reader);
        return properties;
    }

    public T load(String name) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(name);){
            return this.load(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public T load(URI uri) throws IOException {
        return this.load(Paths.get(uri));
    }

    public T load(URL url) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = url.openStream();){
            return this.load(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

