/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.functors.ConstantFactory;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.InstantiateFactory;

public class PrototypeFactory {
    public static Factory getInstance(Object prototype) {
        if (prototype == null) {
            return ConstantFactory.NULL_INSTANCE;
        }
        try {
            Method method = prototype.getClass().getMethod("clone", null);
            return new PrototypeCloneFactory(prototype, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                prototype.getClass().getConstructor(prototype.getClass());
                return new InstantiateFactory(prototype.getClass(), new Class[]{prototype.getClass()}, new Object[]{prototype});
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                if (prototype instanceof Serializable) {
                    return new PrototypeSerializationFactory((Serializable)prototype);
                }
                throw new IllegalArgumentException("The prototype must be cloneable via a public clone method");
            }
        }
    }

    private PrototypeFactory() {
    }

    static class PrototypeCloneFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = 5604271422565175555L;
        private final Object iPrototype;
        private transient Method iCloneMethod;

        private PrototypeCloneFactory(Object prototype, Method method) {
            this.iPrototype = prototype;
            this.iCloneMethod = method;
        }

        private void findCloneMethod() {
            try {
                this.iCloneMethod = this.iPrototype.getClass().getMethod("clone", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("PrototypeCloneFactory: The clone method must exist and be public ");
            }
        }

        @Override
        public Object create() {
            if (this.iCloneMethod == null) {
                this.findCloneMethod();
            }
            try {
                return this.iCloneMethod.invoke(this.iPrototype, null);
            }
            catch (IllegalAccessException ex) {
                throw new FunctorException("PrototypeCloneFactory: Clone method must be public", ex);
            }
            catch (InvocationTargetException ex) {
                throw new FunctorException("PrototypeCloneFactory: Clone method threw an exception", ex);
            }
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            FunctorUtils.checkUnsafeSerialization(PrototypeCloneFactory.class);
            os.defaultWriteObject();
        }

        private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
            FunctorUtils.checkUnsafeSerialization(PrototypeCloneFactory.class);
            is.defaultReadObject();
        }
    }

    static class PrototypeSerializationFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = -8704966966139178833L;
        private final Serializable iPrototype;

        private PrototypeSerializationFactory(Serializable prototype) {
            this.iPrototype = prototype;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object create() {
            Object object;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            ByteArrayInputStream bais = null;
            try {
                ObjectOutputStream out = new ObjectOutputStream(baos);
                out.writeObject(this.iPrototype);
                bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream in = new ObjectInputStream(bais);
                object = in.readObject();
            }
            catch (ClassNotFoundException ex) {
                try {
                    throw new FunctorException(ex);
                    catch (IOException ex2) {
                        throw new FunctorException(ex2);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bais != null) {
                            bais.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (baos == null) throw throwable;
                        baos.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (baos == null) return object;
                baos.close();
                return object;
            }
            catch (IOException iOException) {}
            return object;
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            FunctorUtils.checkUnsafeSerialization(PrototypeSerializationFactory.class);
            os.defaultWriteObject();
        }

        private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
            FunctorUtils.checkUnsafeSerialization(PrototypeSerializationFactory.class);
            is.defaultReadObject();
        }
    }
}

