/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class MultiValueMap
extends AbstractMapDecorator
implements MultiMap {
    private final Factory collectionFactory;
    private transient Collection values;

    public static MultiValueMap decorate(Map map) {
        return new MultiValueMap(map, new ReflectionFactory(ArrayList.class));
    }

    public static MultiValueMap decorate(Map map, Class collectionClass) {
        return new MultiValueMap(map, new ReflectionFactory(collectionClass));
    }

    public static MultiValueMap decorate(Map map, Factory collectionFactory) {
        return new MultiValueMap(map, collectionFactory);
    }

    public MultiValueMap() {
        this(new HashMap(), new ReflectionFactory(ArrayList.class));
    }

    protected MultiValueMap(Map map, Factory collectionFactory) {
        super(map);
        if (collectionFactory == null) {
            throw new IllegalArgumentException("The factory must not be null");
        }
        this.collectionFactory = collectionFactory;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection valuesForKey = this.getCollection(key);
        if (valuesForKey == null) {
            return false;
        }
        boolean removed = valuesForKey.remove(value);
        if (!removed) {
            return false;
        }
        if (valuesForKey.isEmpty()) {
            this.remove(key);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        Set pairs = this.getMap().entrySet();
        if (pairs == null) {
            return false;
        }
        for (Map.Entry keyValuePair : pairs) {
            Collection coll = (Collection)keyValuePair.getValue();
            if (!coll.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object put(Object key, Object value) {
        boolean result = false;
        Collection coll = this.getCollection(key);
        if (coll == null) {
            coll = this.createCollection(1);
            result = coll.add(value);
            if (coll.size() > 0) {
                this.getMap().put(key, coll);
                result = true;
            }
        } else {
            result = coll.add(value);
        }
        return result ? value : null;
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            for (Map.Entry entry : map.entrySet()) {
                Collection coll = (Collection)entry.getValue();
                this.putAll(entry.getKey(), coll);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public boolean containsValue(Object key, Object value) {
        Collection coll = this.getCollection(key);
        if (coll == null) {
            return false;
        }
        return coll.contains(value);
    }

    public Collection getCollection(Object key) {
        return (Collection)this.getMap().get(key);
    }

    public int size(Object key) {
        Collection coll = this.getCollection(key);
        if (coll == null) {
            return 0;
        }
        return coll.size();
    }

    public boolean putAll(Object key, Collection values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        boolean result = false;
        Collection coll = this.getCollection(key);
        if (coll == null) {
            coll = this.createCollection(values.size());
            coll.addAll(values);
            if (coll.size() > 0) {
                this.getMap().put(key, coll);
                result = true;
            }
        } else {
            result = coll.addAll(values);
        }
        return result;
    }

    public Iterator iterator(Object key) {
        if (!this.containsKey(key)) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(key);
    }

    public int totalSize() {
        int total = 0;
        Collection values = this.getMap().values();
        for (Collection coll : values) {
            total += coll.size();
        }
        return total;
    }

    protected Collection createCollection(int size) {
        return (Collection)this.collectionFactory.create();
    }

    private static class ReflectionFactory
    implements Factory {
        private final Class clazz;

        public ReflectionFactory(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object create() {
            try {
                return this.clazz.newInstance();
            }
            catch (Exception ex) {
                throw new FunctorException("Cannot instantiate class: " + this.clazz, ex);
            }
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            IteratorChain chain = new IteratorChain();
            Iterator it = MultiValueMap.this.keySet().iterator();
            while (it.hasNext()) {
                chain.addIterator(new ValuesIterator(it.next()));
            }
            return chain;
        }

        @Override
        public int size() {
            return MultiValueMap.this.totalSize();
        }

        @Override
        public void clear() {
            MultiValueMap.this.clear();
        }
    }

    private class ValuesIterator
    implements Iterator {
        private final Object key;
        private final Collection values;
        private final Iterator iterator;

        public ValuesIterator(Object key) {
            this.key = key;
            this.values = MultiValueMap.this.getCollection(key);
            this.iterator = this.values.iterator();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                MultiValueMap.this.remove(this.key);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

