/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

public class OsgiUtils {
    private static final boolean inOsgiEnvironment;

    static {
        Class<?> classloaderClass = OsgiUtils.class.getClassLoader().getClass();
        inOsgiEnvironment = OsgiUtils.isBundleReference(classloaderClass);
    }

    private static boolean isBundleReference(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != null) {
            if (c.getName().equals("org.osgi.framework.BundleReference")) {
                return true;
            }
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> ifc = classArray[n2];
                if (OsgiUtils.isBundleReference(ifc)) {
                    return true;
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean isRunningInOsgiEnvironment() {
        return inOsgiEnvironment;
    }
}

