/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.annotations.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public final class MethodArgument
implements AnnotatedElement {
    private final int index;
    private final Class<?> parameterType;
    private final Annotation[] annotations;

    public MethodArgument(int index, Class<?> parameterType, Annotation[] annotations) {
        this.index = index;
        this.parameterType = parameterType;
        this.annotations = annotations;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationType == annotation.annotationType()) {
                return (T)((Annotation)annotationType.cast(annotation));
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getAnnotationsArrayCopy();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotationsArrayCopy();
    }

    private Annotation[] getAnnotationsArrayCopy() {
        Annotation[] annotations = new Annotation[this.annotations.length];
        System.arraycopy(this.annotations, 0, annotations, 0, annotations.length);
        return annotations;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationType == annotation.annotationType()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

