/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public final class FileSystem
extends Enum<FileSystem> {
    public static final /* enum */ FileSystem GENERIC = new FileSystem(false, false, Integer.MAX_VALUE, Integer.MAX_VALUE, new char[1], new String[0], false);
    public static final /* enum */ FileSystem LINUX;
    public static final /* enum */ FileSystem MAC_OSX;
    public static final /* enum */ FileSystem WINDOWS;
    private static final boolean IS_OS_LINUX;
    private static final boolean IS_OS_MAC;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    private static final boolean IS_OS_WINDOWS;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final char[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final String[] reservedFileNames;
    private final boolean supportsDriveLetter;
    private static final /* synthetic */ FileSystem[] ENUM$VALUES;

    static {
        char[] cArray = new char[2];
        cArray[1] = 47;
        LINUX = new FileSystem(true, true, 255, 4096, cArray, new String[0], false);
        char[] cArray2 = new char[3];
        cArray2[1] = 47;
        cArray2[2] = 58;
        MAC_OSX = new FileSystem(true, true, 255, 1024, cArray2, new String[0], false);
        char[] cArray3 = new char[41];
        cArray3[1] = '\u0001';
        cArray3[2] = 2;
        cArray3[3] = 3;
        cArray3[4] = 4;
        cArray3[5] = 5;
        cArray3[6] = 6;
        cArray3[7] = 7;
        cArray3[8] = 8;
        cArray3[9] = 9;
        cArray3[10] = 10;
        cArray3[11] = 11;
        cArray3[12] = 12;
        cArray3[13] = 13;
        cArray3[14] = 14;
        cArray3[15] = 15;
        cArray3[16] = 16;
        cArray3[17] = 17;
        cArray3[18] = 18;
        cArray3[19] = 19;
        cArray3[20] = 20;
        cArray3[21] = 21;
        cArray3[22] = 22;
        cArray3[23] = 23;
        cArray3[24] = 24;
        cArray3[25] = 25;
        cArray3[26] = 26;
        cArray3[27] = 27;
        cArray3[28] = 28;
        cArray3[29] = 29;
        cArray3[30] = 30;
        cArray3[31] = 31;
        cArray3[32] = 34;
        cArray3[33] = 42;
        cArray3[34] = 47;
        cArray3[35] = 58;
        cArray3[36] = 60;
        cArray3[37] = 62;
        cArray3[38] = 63;
        cArray3[39] = 92;
        cArray3[40] = 124;
        WINDOWS = new FileSystem(false, true, 255, 32000, cArray3, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "CON", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "NUL", "PRN"}, true);
        ENUM$VALUES = new FileSystem[]{GENERIC, LINUX, MAC_OSX, WINDOWS};
        IS_OS_LINUX = FileSystem.getOsMatchesName("Linux");
        IS_OS_MAC = FileSystem.getOsMatchesName("Mac");
        IS_OS_WINDOWS = FileSystem.getOsMatchesName(OS_NAME_WINDOWS_PREFIX);
    }

    public static FileSystem getCurrent() {
        if (IS_OS_LINUX) {
            return LINUX;
        }
        if (IS_OS_MAC) {
            return MAC_OSX;
        }
        if (IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return GENERIC;
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return FileSystem.isOsNameMatch(FileSystem.getSystemProperty("os.name"), osNamePrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static boolean isOsNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.toUpperCase(Locale.ROOT).startsWith(osNamePrefix.toUpperCase(Locale.ROOT));
    }

    private FileSystem(boolean caseSensitive, boolean casePreserving, int maxFileLength, int maxPathLength, char[] illegalFileNameChars, String[] reservedFileNames, boolean supportsDriveLetter) {
        this.maxFileNameLength = maxFileLength;
        this.maxPathLength = maxPathLength;
        this.illegalFileNameChars = Objects.requireNonNull(illegalFileNameChars, "illegalFileNameChars");
        this.reservedFileNames = Objects.requireNonNull(reservedFileNames, "reservedFileNames");
        this.caseSensitive = caseSensitive;
        this.casePreserving = casePreserving;
        this.supportsDriveLetter = supportsDriveLetter;
    }

    public char[] getIllegalFileNameChars() {
        return (char[])this.illegalFileNameChars.clone();
    }

    public int getMaxFileNameLength() {
        return this.maxFileNameLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public String[] getReservedFileNames() {
        return (String[])this.reservedFileNames.clone();
    }

    public boolean isCasePreserving() {
        return this.casePreserving;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean isIllegalFileNameChar(char c) {
        return Arrays.binarySearch(this.illegalFileNameChars, c) >= 0;
    }

    public boolean isLegalFileName(CharSequence candidate) {
        if (candidate == null || candidate.length() == 0 || candidate.length() > this.maxFileNameLength) {
            return false;
        }
        if (this.isReservedFileName(candidate)) {
            return false;
        }
        int i = 0;
        while (i < candidate.length()) {
            if (this.isIllegalFileNameChar(candidate.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isReservedFileName(CharSequence candidate) {
        return Arrays.binarySearch(this.reservedFileNames, candidate) >= 0;
    }

    public boolean supportsDriveLetter() {
        return this.supportsDriveLetter;
    }

    public String toLegalFileName(String candidate, char replacement) {
        if (this.isIllegalFileNameChar(replacement)) {
            throw new IllegalArgumentException(String.format("The replacement character '%s' cannot be one of the %s illegal characters: %s", replacement == '\u0000' ? "\\0" : Character.valueOf(replacement), this.name(), Arrays.toString(this.illegalFileNameChars)));
        }
        String truncated = candidate.length() > this.maxFileNameLength ? candidate.substring(0, this.maxFileNameLength) : candidate;
        boolean changed = false;
        char[] charArray = truncated.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (this.isIllegalFileNameChar(charArray[i])) {
                charArray[i] = replacement;
                changed = true;
            }
            ++i;
        }
        return changed ? String.valueOf(charArray) : truncated;
    }

    public static FileSystem[] values() {
        FileSystem[] fileSystemArray = ENUM$VALUES;
        int n = fileSystemArray.length;
        FileSystem[] fileSystemArray2 = new FileSystem[n];
        System.arraycopy(ENUM$VALUES, 0, fileSystemArray2, 0, n);
        return fileSystemArray2;
    }

    public static FileSystem valueOf(String string) {
        return Enum.valueOf(FileSystem.class, string);
    }
}

