/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts;

    static {
        int[] nArray = new int[8];
        nArray[0] = 28;
        nArray[1] = 24;
        nArray[2] = 20;
        nArray[3] = 16;
        nArray[4] = 12;
        nArray[5] = 8;
        nArray[6] = 4;
        _shifts = nArray;
    }

    public static void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index;
        StringBuilder buffer = new StringBuilder(74);
        int j = index;
        while (j < data.length) {
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            HexDump.dump(buffer, display_offset).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    HexDump.dump(buffer, data[k + j]);
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            k = 0;
            while (k < chars_read) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                } else {
                    buffer.append('.');
                }
                ++k;
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes(Charset.defaultCharset()));
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
            j += 16;
        }
    }

    private static StringBuilder dump(StringBuilder _lbuffer, long value) {
        int j = 0;
        while (j < 8) {
            _lbuffer.append(_hexcodes[(int)(value >> _shifts[j]) & 0xF]);
            ++j;
        }
        return _lbuffer;
    }

    private static StringBuilder dump(StringBuilder _cbuffer, byte value) {
        int j = 0;
        while (j < 2) {
            _cbuffer.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
            ++j;
        }
        return _cbuffer;
    }
}

