/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class EmptyFileFilter
extends AbstractFileFilter
implements Serializable {
    public static final IOFileFilter EMPTY = new EmptyFileFilter();
    public static final IOFileFilter NOT_EMPTY = EMPTY.negate();
    private static final long serialVersionUID = 3631422087512832211L;

    protected EmptyFileFilter() {
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            return IOUtils.length(files) == 0;
        }
        return file.length() == 0L;
    }

    @Override
    public FileVisitResult accept(Path file, BasicFileAttributes attributes) {
        try {
            if (Files.isDirectory(file, new LinkOption[0])) {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<Path> stream = Files.list(file);){
                    return EmptyFileFilter.toFileVisitResult(!stream.findFirst().isPresent(), file);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return EmptyFileFilter.toFileVisitResult(Files.size(file) == 0L, file);
        }
        catch (IOException e) {
            return this.handle(e);
        }
    }
}

