/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class SingularValueDecomposition {
    private static final double EPS = 2.220446049250313E-16;
    private static final double TINY = 1.6033346880071782E-291;
    private final double[] singularValues;
    private final int m;
    private final int n;
    private final boolean transposed;
    private final RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private final RealMatrix cachedV;
    private RealMatrix cachedVt;
    private final double tol;

    public SingularValueDecomposition(RealMatrix matrix) {
        int i;
        double t;
        int j;
        double[][] A;
        if (matrix.getRowDimension() < matrix.getColumnDimension()) {
            this.transposed = true;
            A = matrix.transpose().getData();
            this.m = matrix.getColumnDimension();
            this.n = matrix.getRowDimension();
        } else {
            this.transposed = false;
            A = matrix.getData();
            this.m = matrix.getRowDimension();
            this.n = matrix.getColumnDimension();
        }
        this.singularValues = new double[this.n];
        double[][] U = new double[this.m][this.n];
        double[][] V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        int nct = FastMath.min(this.m - 1, this.n);
        int nrt = FastMath.max(0, this.n - 2);
        int k = 0;
        while (k < FastMath.max(nct, nrt)) {
            int i2;
            int i3;
            if (k < nct) {
                this.singularValues[k] = 0.0;
                i3 = k;
                while (i3 < this.m) {
                    this.singularValues[k] = FastMath.hypot(this.singularValues[k], A[i3][k]);
                    ++i3;
                }
                if (this.singularValues[k] != 0.0) {
                    if (A[k][k] < 0.0) {
                        this.singularValues[k] = -this.singularValues[k];
                    }
                    i3 = k;
                    while (i3 < this.m) {
                        double[] dArray = A[i3];
                        int n = k;
                        dArray[n] = dArray[n] / this.singularValues[k];
                        ++i3;
                    }
                    double[] dArray = A[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.singularValues[k] = -this.singularValues[k];
            }
            j = k + 1;
            while (j < this.n) {
                if (k < nct && this.singularValues[k] != 0.0) {
                    double t2 = 0.0;
                    i2 = k;
                    while (i2 < this.m) {
                        t2 += A[i2][k] * A[i2][j];
                        ++i2;
                    }
                    t2 = -t2 / A[k][k];
                    i2 = k;
                    while (i2 < this.m) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i2][k];
                        ++i2;
                    }
                }
                e[j] = A[k][j];
                ++j;
            }
            if (k < nct) {
                i3 = k;
                while (i3 < this.m) {
                    U[i3][k] = A[i3][k];
                    ++i3;
                }
            }
            if (k < nrt) {
                e[k] = 0.0;
                i3 = k + 1;
                while (i3 < this.n) {
                    e[k] = FastMath.hypot(e[k], e[i3]);
                    ++i3;
                }
                if (e[k] != 0.0) {
                    if (e[k + 1] < 0.0) {
                        e[k] = -e[k];
                    }
                    i3 = k + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k];
                    }
                    int n = k + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k] = -e[k];
                if (k + 1 < this.m && e[k] != 0.0) {
                    i3 = k + 1;
                    while (i3 < this.m) {
                        work[i3] = 0.0;
                        ++i3;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        int i4 = k + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A[i4][j];
                            ++i4;
                        }
                        ++j;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        double t3 = -e[j] / e[k + 1];
                        i2 = k + 1;
                        while (i2 < this.m) {
                            double[] dArray = A[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t3 * work[i2];
                            ++i2;
                        }
                        ++j;
                    }
                }
                i3 = k + 1;
                while (i3 < this.n) {
                    V[i3][k] = e[i3];
                    ++i3;
                }
            }
            ++k;
        }
        int p = this.n;
        if (nct < this.n) {
            this.singularValues[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.singularValues[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        j = nct;
        while (j < this.n) {
            int i5 = 0;
            while (i5 < this.m) {
                U[i5][j] = 0.0;
                ++i5;
            }
            U[j][j] = 1.0;
            ++j;
        }
        int k2 = nct - 1;
        while (k2 >= 0) {
            if (this.singularValues[k2] != 0.0) {
                int j2 = k2 + 1;
                while (j2 < this.n) {
                    t = 0.0;
                    i = k2;
                    while (i < this.m) {
                        t += U[i][k2] * U[i][j2];
                        ++i;
                    }
                    t = -t / U[k2][k2];
                    i = k2;
                    while (i < this.m) {
                        double[] dArray = U[i];
                        int n = j2;
                        dArray[n] = dArray[n] + t * U[i][k2];
                        ++i;
                    }
                    ++j2;
                }
                i = k2;
                while (i < this.m) {
                    U[i][k2] = -U[i][k2];
                    ++i;
                }
                U[k2][k2] = 1.0 + U[k2][k2];
                i = 0;
                while (i < k2 - 1) {
                    U[i][k2] = 0.0;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m) {
                    U[i][k2] = 0.0;
                    ++i;
                }
                U[k2][k2] = 1.0;
            }
            --k2;
        }
        k2 = this.n - 1;
        while (k2 >= 0) {
            if (k2 < nrt && e[k2] != 0.0) {
                int j3 = k2 + 1;
                while (j3 < this.n) {
                    t = 0.0;
                    i = k2 + 1;
                    while (i < this.n) {
                        t += V[i][k2] * V[i][j3];
                        ++i;
                    }
                    t = -t / V[k2 + 1][k2];
                    i = k2 + 1;
                    while (i < this.n) {
                        double[] dArray = V[i];
                        int n = j3;
                        dArray[n] = dArray[n] + t * V[i][k2];
                        ++i;
                    }
                    ++j3;
                }
            }
            int i6 = 0;
            while (i6 < this.n) {
                V[i6][k2] = 0.0;
                ++i6;
            }
            V[k2][k2] = 1.0;
            --k2;
        }
        int pp = p - 1;
        block34: while (p > 0) {
            int kase;
            int k3 = p - 2;
            while (k3 >= 0) {
                double threshold = 1.6033346880071782E-291 + 2.220446049250313E-16 * (FastMath.abs(this.singularValues[k3]) + FastMath.abs(this.singularValues[k3 + 1]));
                if (!(FastMath.abs(e[k3]) > threshold)) {
                    e[k3] = 0.0;
                    break;
                }
                --k3;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k3) {
                    if (ks == k3) break;
                    double t4 = (ks != p ? FastMath.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? FastMath.abs(e[ks - 1]) : 0.0);
                    if (FastMath.abs(this.singularValues[ks]) <= 1.6033346880071782E-291 + 2.220446049250313E-16 * t4) {
                        this.singularValues[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    int j4 = p - 2;
                    while (j4 >= k3) {
                        t5 = FastMath.hypot(this.singularValues[j4], f);
                        cs = this.singularValues[j4] / t5;
                        sn = f / t5;
                        this.singularValues[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        i7 = 0;
                        while (i7 < this.n) {
                            t5 = cs * V[i7][j4] + sn * V[i7][p - 1];
                            V[i7][p - 1] = -sn * V[i7][j4] + cs * V[i7][p - 1];
                            V[i7][j4] = t5;
                            ++i7;
                        }
                        --j4;
                    }
                    continue block34;
                }
                case 2: {
                    int i7;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    int j5 = k3;
                    while (j5 < p) {
                        t5 = FastMath.hypot(this.singularValues[j5], f);
                        cs = this.singularValues[j5] / t5;
                        sn = f / t5;
                        this.singularValues[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        i7 = 0;
                        while (i7 < this.m) {
                            t5 = cs * U[i7][j5] + sn * U[i7][k3 - 1];
                            U[i7][k3 - 1] = -sn * U[i7][j5] + cs * U[i7][k3 - 1];
                            U[i7][j5] = t5;
                            ++i7;
                        }
                        ++j5;
                    }
                    continue block34;
                }
                case 3: {
                    double maxPm1Pm2 = FastMath.max(FastMath.abs(this.singularValues[p - 1]), FastMath.abs(this.singularValues[p - 2]));
                    double scale = FastMath.max(FastMath.max(FastMath.max(maxPm1Pm2, FastMath.abs(e[p - 2])), FastMath.abs(this.singularValues[k3])), FastMath.abs(e[k3]));
                    double sp = this.singularValues[p - 1] / scale;
                    double spm1 = this.singularValues[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.singularValues[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = FastMath.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    int j6 = k3;
                    while (j6 < p - 1) {
                        double t6 = FastMath.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.singularValues[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.singularValues[j6];
                        g = sn * this.singularValues[j6 + 1];
                        this.singularValues[j6 + 1] = cs * this.singularValues[j6 + 1];
                        int i8 = 0;
                        while (i8 < this.n) {
                            t6 = cs * V[i8][j6] + sn * V[i8][j6 + 1];
                            V[i8][j6 + 1] = -sn * V[i8][j6] + cs * V[i8][j6 + 1];
                            V[i8][j6] = t6;
                            ++i8;
                        }
                        t6 = FastMath.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.singularValues[j6] = t6;
                        f = cs * e[j6] + sn * this.singularValues[j6 + 1];
                        this.singularValues[j6 + 1] = -sn * e[j6] + cs * this.singularValues[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (j6 < this.m - 1) {
                            i8 = 0;
                            while (i8 < this.m) {
                                t6 = cs * U[i8][j6] + sn * U[i8][j6 + 1];
                                U[i8][j6 + 1] = -sn * U[i8][j6] + cs * U[i8][j6 + 1];
                                U[i8][j6] = t6;
                                ++i8;
                            }
                        }
                        ++j6;
                    }
                    e[p - 2] = f;
                    break;
                }
                default: {
                    if (this.singularValues[k3] <= 0.0) {
                        this.singularValues[k3] = this.singularValues[k3] < 0.0 ? -this.singularValues[k3] : 0.0;
                        int i9 = 0;
                        while (i9 <= pp) {
                            V[i9][k3] = -V[i9][k3];
                            ++i9;
                        }
                    }
                    while (k3 < pp) {
                        int i10;
                        if (this.singularValues[k3] >= this.singularValues[k3 + 1]) break;
                        double t7 = this.singularValues[k3];
                        this.singularValues[k3] = this.singularValues[k3 + 1];
                        this.singularValues[k3 + 1] = t7;
                        if (k3 < this.n - 1) {
                            i10 = 0;
                            while (i10 < this.n) {
                                t7 = V[i10][k3 + 1];
                                V[i10][k3 + 1] = V[i10][k3];
                                V[i10][k3] = t7;
                                ++i10;
                            }
                        }
                        if (k3 < this.m - 1) {
                            i10 = 0;
                            while (i10 < this.m) {
                                t7 = U[i10][k3 + 1];
                                U[i10][k3 + 1] = U[i10][k3];
                                U[i10][k3] = t7;
                                ++i10;
                            }
                        }
                        ++k3;
                    }
                    --p;
                }
            }
        }
        this.tol = FastMath.max((double)this.m * this.singularValues[0] * 2.220446049250313E-16, FastMath.sqrt(Precision.SAFE_MIN));
        if (!this.transposed) {
            this.cachedU = MatrixUtils.createRealMatrix(U);
            this.cachedV = MatrixUtils.createRealMatrix(V);
        } else {
            this.cachedU = MatrixUtils.createRealMatrix(V);
            this.cachedV = MatrixUtils.createRealMatrix(U);
        }
    }

    public RealMatrix getU() {
        return this.cachedU;
    }

    public RealMatrix getUT() {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() {
        return this.cachedV;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double minSingularValue) {
        int p = this.singularValues.length;
        int dimension = 0;
        while (dimension < p && this.singularValues[dimension] >= minSingularValue) {
            ++dimension;
        }
        if (dimension == 0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, (Number)minSingularValue, this.singularValues[0], true);
        }
        final double[][] data = new double[dimension][p];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            @Override
            public void visit(int row, int column, double value) {
                data[row][column] = value / SingularValueDecomposition.this.singularValues[row];
            }
        }, 0, dimension - 1, 0, p - 1);
        Array2DRowRealMatrix jv = new Array2DRowRealMatrix(data, false);
        return jv.transpose().multiply(jv);
    }

    public double getNorm() {
        return this.singularValues[0];
    }

    public double getConditionNumber() {
        return this.singularValues[0] / this.singularValues[this.n - 1];
    }

    public double getInverseConditionNumber() {
        return this.singularValues[this.n - 1] / this.singularValues[0];
    }

    public int getRank() {
        int r = 0;
        int i = 0;
        while (i < this.singularValues.length) {
            if (this.singularValues[i] > this.tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == this.m, this.tol);
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private boolean nonSingular;

        private Solver(double[] singularValues, RealMatrix uT, RealMatrix v, boolean nonSingular, double tol) {
            double[][] suT = uT.getData();
            int i = 0;
            while (i < singularValues.length) {
                double a = singularValues[i] > tol ? 1.0 / singularValues[i] : 0.0;
                double[] suTi = suT[i];
                int j = 0;
                while (j < suTi.length) {
                    int n = j++;
                    suTi[n] = suTi[n] * a;
                }
                ++i;
            }
            this.pseudoInverse = v.multiply(new Array2DRowRealMatrix(suT, false));
            this.nonSingular = nonSingular;
        }

        @Override
        public RealVector solve(RealVector b) {
            return this.pseudoInverse.operate(b);
        }

        @Override
        public RealMatrix solve(RealMatrix b) {
            return this.pseudoInverse.multiply(b);
        }

        @Override
        public boolean isNonSingular() {
            return this.nonSingular;
        }

        @Override
        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

