/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class EulerStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;

    public EulerStepInterpolator() {
    }

    EulerStepInterpolator(EulerStepInterpolator interpolator) {
        super(interpolator);
    }

    @Override
    protected StepInterpolator doCopy() {
        return new EulerStepInterpolator(this);
    }

    @Override
    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) {
        if (this.previousState != null && theta <= 0.5) {
            int i = 0;
            while (i < this.interpolatedState.length) {
                this.interpolatedState[i] = this.previousState[i] + theta * this.h * this.yDotK[0][i];
                ++i;
            }
            System.arraycopy(this.yDotK[0], 0, this.interpolatedDerivatives, 0, this.interpolatedDerivatives.length);
        } else {
            int i = 0;
            while (i < this.interpolatedState.length) {
                this.interpolatedState[i] = this.currentState[i] - oneMinusThetaH * this.yDotK[0][i];
                ++i;
            }
            System.arraycopy(this.yDotK[0], 0, this.interpolatedDerivatives, 0, this.interpolatedDerivatives.length);
        }
    }
}

