/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import java.util.Arrays;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.general.AbstractLeastSquaresOptimizer;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

@Deprecated
public class LevenbergMarquardtOptimizer
extends AbstractLeastSquaresOptimizer {
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;
    private double[] weightedResidual;
    private double[][] weightedJacobian;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        this(100.0, checker, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double initialStepBoundFactor, ConvergenceChecker<PointVectorValuePair> checker, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, double threshold) {
        super(checker);
        this.initialStepBoundFactor = initialStepBoundFactor;
        this.costRelativeTolerance = costRelativeTolerance;
        this.parRelativeTolerance = parRelativeTolerance;
        this.orthoTolerance = orthoTolerance;
        this.qrRankingThreshold = threshold;
    }

    public LevenbergMarquardtOptimizer(double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance) {
        this(100.0, costRelativeTolerance, parRelativeTolerance, orthoTolerance, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double initialStepBoundFactor, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, double threshold) {
        super(null);
        this.initialStepBoundFactor = initialStepBoundFactor;
        this.costRelativeTolerance = costRelativeTolerance;
        this.parRelativeTolerance = parRelativeTolerance;
        this.orthoTolerance = orthoTolerance;
        this.qrRankingThreshold = threshold;
    }

    @Override
    protected PointVectorValuePair doOptimize() {
        int nR = this.getTarget().length;
        double[] currentPoint = this.getStartPoint();
        int nC = currentPoint.length;
        this.solvedCols = FastMath.min(nR, nC);
        this.diagR = new double[nC];
        this.jacNorm = new double[nC];
        this.beta = new double[nC];
        this.permutation = new int[nC];
        this.lmDir = new double[nC];
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[nC];
        double[] oldX = new double[nC];
        double[] oldRes = new double[nR];
        double[] oldObj = new double[nR];
        double[] qtf = new double[nR];
        double[] work1 = new double[nC];
        double[] work2 = new double[nC];
        double[] work3 = new double[nC];
        RealMatrix weightMatrixSqrt = this.getWeightSquareRoot();
        double[] currentObjective = this.computeObjectiveValue(currentPoint);
        double[] currentResiduals = this.computeResiduals(currentObjective);
        PointVectorValuePair current = new PointVectorValuePair(currentPoint, currentObjective);
        double currentCost = this.computeCost(currentResiduals);
        this.lmPar = 0.0;
        boolean firstIteration = true;
        int iter = 0;
        ConvergenceChecker<PointVectorValuePair> checker = this.getConvergenceChecker();
        block0: while (true) {
            int j;
            ++iter;
            PointVectorValuePair previous = current;
            this.qrDecomposition(this.computeWeightedJacobian(currentPoint));
            this.weightedResidual = weightMatrixSqrt.operate(currentResiduals);
            int i = 0;
            while (i < nR) {
                qtf[i] = this.weightedResidual[i];
                ++i;
            }
            this.qTy(qtf);
            int k = 0;
            while (k < this.solvedCols) {
                int pk = this.permutation[k];
                this.weightedJacobian[k][pk] = this.diagR[pk];
                ++k;
            }
            if (firstIteration) {
                xNorm = 0.0;
                k = 0;
                while (k < nC) {
                    double dk = this.jacNorm[k];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * currentPoint[k];
                    xNorm += xk * xk;
                    diag[k] = dk;
                    ++k;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (currentCost != 0.0) {
                j = 0;
                while (j < this.solvedCols) {
                    int pj = this.permutation[j];
                    double s = this.jacNorm[pj];
                    if (s != 0.0) {
                        double sum = 0.0;
                        int i2 = 0;
                        while (i2 <= j) {
                            sum += this.weightedJacobian[i2][pj] * qtf[i2];
                            ++i2;
                        }
                        maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s * currentCost));
                    }
                    ++j;
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                this.setCost(currentCost);
                this.point = current.getPoint();
                return current;
            }
            j = 0;
            while (j < nC) {
                diag[j] = FastMath.max(diag[j], this.jacNorm[j]);
                ++j;
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                int j2 = 0;
                while (j2 < this.solvedCols) {
                    int pj = this.permutation[j2];
                    oldX[pj] = currentPoint[pj];
                    ++j2;
                }
                double previousCost = currentCost;
                double[] tmpVec = this.weightedResidual;
                this.weightedResidual = oldRes;
                oldRes = tmpVec;
                tmpVec = currentObjective;
                currentObjective = oldObj;
                oldObj = tmpVec;
                this.determineLMParameter(qtf, delta, diag, work1, work2, work3);
                double lmNorm = 0.0;
                int j3 = 0;
                while (j3 < this.solvedCols) {
                    int pj = this.permutation[j3];
                    this.lmDir[pj] = -this.lmDir[pj];
                    currentPoint[pj] = oldX[pj] + this.lmDir[pj];
                    double s = diag[pj] * this.lmDir[pj];
                    lmNorm += s * s;
                    ++j3;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                currentObjective = this.computeObjectiveValue(currentPoint);
                currentResiduals = this.computeResiduals(currentObjective);
                current = new PointVectorValuePair(currentPoint, currentObjective);
                currentCost = this.computeCost(currentResiduals);
                double actRed = -1.0;
                if (0.1 * currentCost < previousCost) {
                    double r = currentCost / previousCost;
                    actRed = 1.0 - r * r;
                }
                int j4 = 0;
                while (j4 < this.solvedCols) {
                    int pj = this.permutation[j4];
                    double dirJ = this.lmDir[pj];
                    work1[j4] = 0.0;
                    int i3 = 0;
                    while (i3 <= j4) {
                        int n = i3;
                        work1[n] = work1[n] + this.weightedJacobian[i3][pj] * dirJ;
                        ++i3;
                    }
                    ++j4;
                }
                double coeff1 = 0.0;
                int j5 = 0;
                while (j5 < this.solvedCols) {
                    coeff1 += work1[j5] * work1[j5];
                    ++j5;
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d2 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * currentCost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    int k2 = 0;
                    while (k2 < nC) {
                        double xK = diag[k2] * currentPoint[k2];
                        xNorm += xK * xK;
                        ++k2;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                    if (checker != null && checker.converged(iter, previous, current)) {
                        this.setCost(currentCost);
                        this.point = current.getPoint();
                        return current;
                    }
                } else {
                    currentCost = previousCost;
                    int j6 = 0;
                    while (j6 < this.solvedCols) {
                        int pj = this.permutation[j6];
                        currentPoint[pj] = oldX[pj];
                        ++j6;
                    }
                    tmpVec = this.weightedResidual;
                    this.weightedResidual = oldRes;
                    oldRes = tmpVec;
                    tmpVec = currentObjective;
                    currentObjective = oldObj;
                    oldObj = tmpVec;
                    current = new PointVectorValuePair(currentPoint, currentObjective);
                }
                if (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm) {
                    this.setCost(currentCost);
                    this.point = current.getPoint();
                    return current;
                }
                if (FastMath.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(delta <= 2.2204E-16 * xNorm)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(maxCosine <= 2.2204E-16));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        double sum;
        int pj;
        int j;
        int nC = this.weightedJacobian[0].length;
        int j2 = 0;
        while (j2 < this.rank) {
            this.lmDir[this.permutation[j2]] = qy[j2];
            ++j2;
        }
        j2 = this.rank;
        while (j2 < nC) {
            this.lmDir[this.permutation[j2]] = 0.0;
            ++j2;
        }
        int k = this.rank - 1;
        while (k >= 0) {
            int pk = this.permutation[k];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            int i = 0;
            while (i < k) {
                int n = this.permutation[i];
                this.lmDir[n] = this.lmDir[n] - ypk * this.weightedJacobian[i][pk];
                ++i;
            }
            this.lmDir[pk] = ypk;
            --k;
        }
        double dxNorm = 0.0;
        int j3 = 0;
        while (j3 < this.solvedCols) {
            double s;
            int pj2 = this.permutation[j3];
            work1[pj2] = s = diag[pj2] * this.lmDir[pj2];
            dxNorm += s * s;
            ++j3;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            j = 0;
            while (j < this.solvedCols) {
                int n = pj = this.permutation[j];
                work1[n] = work1[n] * (diag[pj] / dxNorm);
                ++j;
            }
            double sum2 = 0.0;
            j = 0;
            while (j < this.solvedCols) {
                double s;
                pj = this.permutation[j];
                sum = 0.0;
                int i = 0;
                while (i < j) {
                    sum += this.weightedJacobian[i][pj] * work1[this.permutation[i]];
                    ++i;
                }
                work1[pj] = s = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s * s;
                ++j;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            sum = 0.0;
            int i = 0;
            while (i <= j) {
                sum += this.weightedJacobian[i][pj] * qy[i];
                ++i;
            }
            sum2 += (sum /= diag[pj]) * sum;
            ++j;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / FastMath.min(delta, 0.1);
        }
        this.lmPar = FastMath.min(paru, FastMath.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        int countdown = 10;
        while (countdown >= 0) {
            int pj3;
            int pj4;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(this.lmPar);
            int j4 = 0;
            while (j4 < this.solvedCols) {
                pj4 = this.permutation[j4];
                work1[pj4] = sPar * diag[pj4];
                ++j4;
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            j4 = 0;
            while (j4 < this.solvedCols) {
                double s;
                pj4 = this.permutation[j4];
                work3[pj4] = s = diag[pj4] * this.lmDir[pj4];
                dxNorm += s * s;
                ++j4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            int j5 = 0;
            while (j5 < this.solvedCols) {
                pj3 = this.permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
                ++j5;
            }
            j5 = 0;
            while (j5 < this.solvedCols) {
                int n = pj3 = this.permutation[j5];
                work1[n] = work1[n] / work2[j5];
                double tmp = work1[pj3];
                int i = j5 + 1;
                while (i < this.solvedCols) {
                    int n2 = this.permutation[i];
                    work1[n2] = work1[n2] - this.weightedJacobian[i][pj3] * tmp;
                    ++i;
                }
                ++j5;
            }
            sum2 = 0.0;
            j5 = 0;
            while (j5 < this.solvedCols) {
                double s = work1[this.permutation[j5]];
                sum2 += s * s;
                ++j5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, this.lmPar);
            }
            this.lmPar = FastMath.max(parl, this.lmPar + correction);
            --countdown;
        }
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int pj;
        int j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            int i = j + 1;
            while (i < this.solvedCols) {
                this.weightedJacobian[i][pj] = this.weightedJacobian[j][this.permutation[i]];
                ++i;
            }
            this.lmDir[j] = this.diagR[pj];
            work[j] = qy[j];
            ++j;
        }
        j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j + 1, lmDiag.length, 0.0);
            }
            lmDiag[j] = dpj;
            double qtbpj = 0.0;
            int k = j;
            while (k < this.solvedCols) {
                int pk = this.permutation[k];
                if (lmDiag[k] != 0.0) {
                    double cos;
                    double sin;
                    double rkk = this.weightedJacobian[k][pk];
                    if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k])) {
                        double cotan = rkk / lmDiag[k];
                        sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                        cos = sin * cotan;
                    } else {
                        double tan = lmDiag[k] / rkk;
                        cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                        sin = cos * tan;
                    }
                    this.weightedJacobian[k][pk] = cos * rkk + sin * lmDiag[k];
                    double temp = cos * work[k] + sin * qtbpj;
                    qtbpj = -sin * work[k] + cos * qtbpj;
                    work[k] = temp;
                    int i = k + 1;
                    while (i < this.solvedCols) {
                        double rik = this.weightedJacobian[i][pk];
                        double temp2 = cos * rik + sin * lmDiag[i];
                        lmDiag[i] = -sin * rik + cos * lmDiag[i];
                        this.weightedJacobian[i][pk] = temp2;
                        ++i;
                    }
                }
                ++k;
            }
            lmDiag[j] = this.weightedJacobian[j][this.permutation[j]];
            this.weightedJacobian[j][this.permutation[j]] = this.lmDir[j];
            ++j;
        }
        int nSing = this.solvedCols;
        int j2 = 0;
        while (j2 < this.solvedCols) {
            if (lmDiag[j2] == 0.0 && nSing == this.solvedCols) {
                nSing = j2;
            }
            if (nSing < this.solvedCols) {
                work[j2] = 0.0;
            }
            ++j2;
        }
        if (nSing > 0) {
            j2 = nSing - 1;
            while (j2 >= 0) {
                int pj2 = this.permutation[j2];
                double sum = 0.0;
                int i = j2 + 1;
                while (i < nSing) {
                    sum += this.weightedJacobian[i][pj2] * work[i];
                    ++i;
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
                --j2;
            }
        }
        j2 = 0;
        while (j2 < this.lmDir.length) {
            this.lmDir[this.permutation[j2]] = work[j2];
            ++j2;
        }
    }

    private void qrDecomposition(RealMatrix jacobian) throws ConvergenceException {
        this.weightedJacobian = jacobian.scalarMultiply(-1.0).getData();
        int nR = this.weightedJacobian.length;
        int nC = this.weightedJacobian[0].length;
        int k = 0;
        while (k < nC) {
            this.permutation[k] = k;
            double norm2 = 0.0;
            int i = 0;
            while (i < nR) {
                double akk = this.weightedJacobian[i][k];
                norm2 += akk * akk;
                ++i;
            }
            this.jacNorm[k] = FastMath.sqrt(norm2);
            ++k;
        }
        k = 0;
        while (k < nC) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            int i = k;
            while (i < nC) {
                double norm2 = 0.0;
                int j = k;
                while (j < nR) {
                    double aki = this.weightedJacobian[j][this.permutation[i]];
                    norm2 += aki * aki;
                    ++j;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, nR, nC);
                }
                if (norm2 > ak2) {
                    nextColumn = i;
                    ak2 = norm2;
                }
                ++i;
            }
            if (ak2 <= this.qrRankingThreshold) {
                this.rank = k;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k];
            this.permutation[k] = pk;
            double akk = this.weightedJacobian[k][pk];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            double[] dArray = this.weightedJacobian[k];
            int n = pk;
            dArray[n] = dArray[n] - alpha;
            int dk = nC - 1 - k;
            while (dk > 0) {
                double gamma = 0.0;
                int j = k;
                while (j < nR) {
                    gamma += this.weightedJacobian[j][pk] * this.weightedJacobian[j][this.permutation[k + dk]];
                    ++j;
                }
                gamma *= betak;
                j = k;
                while (j < nR) {
                    double[] dArray2 = this.weightedJacobian[j];
                    int n2 = this.permutation[k + dk];
                    dArray2[n2] = dArray2[n2] - gamma * this.weightedJacobian[j][pk];
                    ++j;
                }
                --dk;
            }
            ++k;
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y) {
        int nR = this.weightedJacobian.length;
        int nC = this.weightedJacobian[0].length;
        int k = 0;
        while (k < nC) {
            int pk = this.permutation[k];
            double gamma = 0.0;
            int i = k;
            while (i < nR) {
                gamma += this.weightedJacobian[i][pk] * y[i];
                ++i;
            }
            gamma *= this.beta[pk];
            i = k;
            while (i < nR) {
                int n = i;
                y[n] = y[n] - gamma * this.weightedJacobian[i][pk];
                ++i;
            }
            ++k;
        }
    }
}

