/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ILogEventListener;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="ObservableAppender", category="Core", elementType="appender")
public class ObservableAppender
extends AbstractAppender {
    private final Set<ILogEventListener> listeners = new HashSet<ILogEventListener>();

    protected ObservableAppender(String name, Filter filter) {
        super(name, filter, null);
    }

    @PluginFactory
    public static ObservableAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new ObservableAppender(name, filter);
    }

    @Override
    public void append(LogEvent event) {
        this.listeners.forEach(l -> l.log(event));
    }

    public void addListener(ILogEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILogEventListener listener) {
        this.listeners.remove(listener);
    }
}

