/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Objects;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class CommonsCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final String name;
    private final File source;
    private final File destination;
    private final boolean deleteSource;

    public CommonsCompressAction(String name, File source, File destination, boolean deleteSource) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.name = name;
        this.source = source;
        this.destination = destination;
        this.deleteSource = deleteSource;
    }

    @Override
    public boolean execute() throws IOException {
        return CommonsCompressAction.execute(this.name, this.source, this.destination, this.deleteSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(String name, File source, File destination, boolean deleteSource) throws IOException {
        block19: {
            if (!source.exists()) {
                return false;
            }
            LOGGER.debug("Starting {} compression of {}", (Object)name, (Object)source.getPath());
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try {
                    FileInputStream input = new FileInputStream(source);
                    try {
                        try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)new CompressorStreamFactory().createCompressorOutputStream(name, (OutputStream)new FileOutputStream(destination)));){
                            IOUtils.copy((InputStream)input, (OutputStream)output, (int)8192);
                            LOGGER.debug("Finished {} compression of {}", (Object)name, (Object)source.getPath());
                        }
                        if (input == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (CompressorException e) {
                throw new IOException(e);
            }
        }
        if (!deleteSource) return true;
        try {
            if (Files.deleteIfExists(source.toPath())) {
                LOGGER.debug("Deleted {}", (Object)source.toString());
                return true;
            }
            LOGGER.warn("Unable to delete {} after {} compression. File did not exist", (Object)source.toString(), (Object)name);
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to delete {} after {} compression, {}", (Object)source.toString(), (Object)name, (Object)ex.getMessage());
        }
        return true;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during " + this.name + " compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return String.valueOf(CommonsCompressAction.class.getSimpleName()) + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public String getName() {
        return this.name;
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }
}

