/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;

final class RunLengthDecodeFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog(RunLengthDecodeFilter.class);
    private static final int RUN_LENGTH_EOD = 128;

    RunLengthDecodeFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        int dupAmount;
        byte[] buffer = new byte[128];
        block0: while ((dupAmount = encoded.read()) != -1 && dupAmount != 128) {
            if (dupAmount <= 127) {
                int amountToCopy = dupAmount + 1;
                while (amountToCopy > 0) {
                    int compressedRead = encoded.read(buffer, 0, amountToCopy);
                    if (compressedRead == -1) continue block0;
                    decoded.write(buffer, 0, compressedRead);
                    amountToCopy -= compressedRead;
                }
                continue;
            }
            int dupByte = encoded.read();
            if (dupByte == -1) break;
            int i = 0;
            while (i < 257 - dupAmount) {
                decoded.write(dupByte);
                ++i;
            }
        }
        return new DecodeResult(parameters);
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        LOG.warn((Object)"RunLengthDecodeFilter.encode is not implemented yet, skipping this stream.");
    }
}

