/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.util.Charsets;

public final class PDICCBased
extends PDCIEBasedColorSpace {
    private static final Log LOG = LogFactory.getLog(PDICCBased.class);
    private final PDStream stream;
    private int numberOfComponents = -1;
    private ICC_Profile iccProfile;
    private PDColorSpace alternateColorSpace;
    private ICC_ColorSpace awtColorSpace;
    private PDColor initialColor;
    private boolean isRGB = false;
    private boolean useOnlyAlternateColorSpace = false;
    private static final boolean IS_KCMS;

    static {
        String cmmProperty = System.getProperty("sun.java2d.cmm");
        boolean result = false;
        if (!PDICCBased.isMinJdk8()) {
            result = true;
        } else if ("sun.java2d.cmm.kcms.KcmsServiceProvider".equals(cmmProperty)) {
            try {
                Class.forName("sun.java2d.cmm.kcms.KcmsServiceProvider");
                result = true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        IS_KCMS = result;
    }

    public PDICCBased(PDDocument doc) {
        this.array = new COSArray();
        this.array.add(COSName.ICCBASED);
        this.stream = new PDStream(doc);
        this.array.add(this.stream);
    }

    @Deprecated
    public PDICCBased(COSArray iccArray) throws IOException {
        PDICCBased.checkArray(iccArray);
        this.useOnlyAlternateColorSpace = System.getProperty("org.apache.pdfbox.rendering.UseAlternateInsteadOfICCColorSpace") != null;
        this.array = iccArray;
        this.stream = new PDStream((COSStream)iccArray.getObject(1));
        this.loadICCProfile();
    }

    public static PDICCBased create(COSArray iccArray, PDResources resources) throws IOException {
        PDColorSpace space;
        PDICCBased.checkArray(iccArray);
        COSBase base = iccArray.get(1);
        COSObject indirect = null;
        if (base instanceof COSObject) {
            indirect = (COSObject)base;
        }
        if (indirect != null && resources != null && resources.getResourceCache() != null && (space = resources.getResourceCache().getColorSpace(indirect)) instanceof PDICCBased) {
            return space;
        }
        space = new PDICCBased(iccArray);
        if (indirect != null && resources != null && resources.getResourceCache() != null) {
            resources.getResourceCache().put(indirect, space);
        }
        return space;
    }

    private static void checkArray(COSArray iccArray) throws IOException {
        if (iccArray.size() < 2) {
            throw new IOException("ICCBased colorspace array must have two elements");
        }
        if (!(iccArray.getObject(1) instanceof COSStream)) {
            throw new IOException("ICCBased colorspace array must have a stream as second element");
        }
    }

    @Override
    public String getName() {
        return COSName.ICCBASED.getName();
    }

    public PDStream getPDStream() {
        return this.stream;
    }

    /*
     * Exception decompiling
     */
    private void loadICCProfile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fallbackToAlternateColorSpace(Exception e) throws IOException {
        this.awtColorSpace = null;
        this.alternateColorSpace = this.getAlternateColorSpace();
        if (this.alternateColorSpace.equals(PDDeviceRGB.INSTANCE)) {
            this.isRGB = true;
        }
        if (e != null) {
            LOG.warn((Object)("Can't read embedded ICC profile (" + e.getLocalizedMessage() + "), using alternate color space: " + this.alternateColorSpace.getName()));
        }
        this.initialColor = this.alternateColorSpace.getInitialColor();
    }

    private boolean is_sRGB(ICC_Profile profile) {
        byte[] bytes = Arrays.copyOfRange(profile.getData(1751474532), 52, 59);
        String deviceModel = new String(bytes, Charsets.US_ASCII).trim();
        return deviceModel.equals("sRGB");
    }

    private static ICC_Profile ensureDisplayProfile(ICC_Profile profile) {
        byte[] profileData;
        if (profile.getProfileClass() != 1 && (profileData = profile.getData())[64] == 0) {
            LOG.warn((Object)"ICC profile is Perceptual, ignoring, treating as Display class");
            PDICCBased.intToBigEndian(1835955314, profileData, 12);
            return ICC_Profile.getInstance(profileData);
        }
        return profile;
    }

    private static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }

    @Override
    public float[] toRGB(float[] value) throws IOException {
        if (this.isRGB) {
            return value;
        }
        if (this.awtColorSpace != null) {
            return this.awtColorSpace.toRGB(this.clampColors(this.awtColorSpace, value));
        }
        return this.alternateColorSpace.toRGB(value);
    }

    private float[] clampColors(ICC_ColorSpace cs, float[] value) {
        float[] result = new float[value.length];
        int i = 0;
        while (i < value.length) {
            float minValue = cs.getMinValue(i);
            float maxValue = cs.getMaxValue(i);
            result[i] = value[i] < minValue ? minValue : (value[i] > maxValue ? maxValue : value[i]);
            ++i;
        }
        return result;
    }

    @Override
    public BufferedImage toRGBImage(WritableRaster raster) throws IOException {
        if (this.awtColorSpace != null) {
            return this.toRGBImageAWT(raster, this.awtColorSpace);
        }
        return this.alternateColorSpace.toRGBImage(raster);
    }

    @Override
    public BufferedImage toRawImage(WritableRaster raster) throws IOException {
        if (this.awtColorSpace == null) {
            return this.alternateColorSpace.toRawImage(raster);
        }
        return this.toRawImage(raster, this.awtColorSpace);
    }

    @Override
    public int getNumberOfComponents() {
        if (this.numberOfComponents < 0) {
            int numIccComponents;
            this.numberOfComponents = this.stream.getCOSObject().getInt(COSName.N);
            if (this.iccProfile != null && (numIccComponents = this.iccProfile.getNumComponents()) != this.numberOfComponents) {
                LOG.warn((Object)("Using " + numIccComponents + " components from ICC profile info instead of " + this.numberOfComponents + " components from /N entry"));
                this.numberOfComponents = numIccComponents;
            }
        }
        return this.numberOfComponents;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        if (this.awtColorSpace != null) {
            int n = this.getNumberOfComponents();
            float[] decode = new float[n * 2];
            int i = 0;
            while (i < n) {
                decode[i * 2] = this.awtColorSpace.getMinValue(i);
                decode[i * 2 + 1] = this.awtColorSpace.getMaxValue(i);
                ++i;
            }
            return decode;
        }
        return this.alternateColorSpace.getDefaultDecode(bitsPerComponent);
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        COSArray alternateArray;
        COSBase alternate = this.stream.getCOSObject().getDictionaryObject(COSName.ALTERNATE);
        if (alternate == null) {
            alternateArray = new COSArray();
            int numComponents = this.getNumberOfComponents();
            alternateArray.add(switch (numComponents) {
                case 1 -> COSName.DEVICEGRAY;
                case 3 -> COSName.DEVICERGB;
                case 4 -> COSName.DEVICECMYK;
                default -> throw new IOException("Unknown color space number of components:" + numComponents);
            });
        } else if (alternate instanceof COSArray) {
            alternateArray = (COSArray)alternate;
        } else if (alternate instanceof COSName) {
            alternateArray = new COSArray();
            alternateArray.add(alternate);
        } else {
            throw new IOException("Error: expected COSArray or COSName and not " + alternate.getClass().getName());
        }
        return PDColorSpace.create(alternateArray);
    }

    public PDRange getRangeForComponent(int n) {
        COSArray rangeArray = (COSArray)this.stream.getCOSObject().getDictionaryObject(COSName.RANGE);
        if (rangeArray == null || rangeArray.size() < this.getNumberOfComponents() * 2) {
            return new PDRange();
        }
        return new PDRange(rangeArray, n);
    }

    public COSStream getMetadata() {
        return (COSStream)this.stream.getCOSObject().getDictionaryObject(COSName.METADATA);
    }

    public int getColorSpaceType() {
        if (this.iccProfile != null) {
            return this.iccProfile.getColorSpaceType();
        }
        switch (this.alternateColorSpace.getNumberOfComponents()) {
            case 1: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 9;
            }
        }
        return -1;
    }

    @Deprecated
    public void setNumberOfComponents(int n) {
        this.numberOfComponents = n;
        this.stream.getCOSObject().setInt(COSName.N, n);
    }

    public void setAlternateColorSpaces(List<PDColorSpace> list) {
        COSArray altArray = null;
        if (list != null) {
            altArray = COSArrayList.converterToCOSArray(list);
        }
        this.stream.getCOSObject().setItem(COSName.ALTERNATE, (COSBase)altArray);
    }

    public void setRangeForComponent(PDRange range, int n) {
        COSArray rangeArray = (COSArray)this.stream.getCOSObject().getDictionaryObject(COSName.RANGE);
        if (rangeArray == null) {
            rangeArray = new COSArray();
            this.stream.getCOSObject().setItem(COSName.RANGE, (COSBase)rangeArray);
        }
        while (rangeArray.size() < (n + 1) * 2) {
            rangeArray.add(new COSFloat(0.0f));
            rangeArray.add(new COSFloat(1.0f));
        }
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }

    public void setMetadata(COSStream metadata) {
        this.stream.getCOSObject().setItem(COSName.METADATA, (COSBase)metadata);
    }

    boolean isSRGB() {
        return this.isRGB;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "{numberOfComponents: " + this.getNumberOfComponents() + "}";
    }

    private static boolean isMinJdk8() {
        String version = System.getProperty("java.specification.version");
        StringTokenizer st = new StringTokenizer(version, ".");
        try {
            int major = Integer.parseInt(st.nextToken());
            int minor = 0;
            if (st.hasMoreTokens()) {
                minor = Integer.parseInt(st.nextToken());
            }
            return major > 1 || major == 1 && minor >= 8;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }
}

