/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.geom.Point2D;

class CubicBezierCurve {
    private final Point2D[] controlPoints;
    private final int level;
    private final Point2D[] curve;

    CubicBezierCurve(Point2D[] ctrlPnts, int l) {
        this.controlPoints = (Point2D[])ctrlPnts.clone();
        this.level = l;
        this.curve = this.getPoints(this.level);
    }

    int getLevel() {
        return this.level;
    }

    private Point2D[] getPoints(int l) {
        if (l < 0) {
            l = 0;
        }
        int sz = (1 << l) + 1;
        Point2D[] res = new Point2D[sz];
        double step = 1.0 / (double)(sz - 1);
        double t = -step;
        int i = 0;
        while (i < sz) {
            double tmpX = (1.0 - (t += step)) * (1.0 - t) * (1.0 - t) * this.controlPoints[0].getX() + 3.0 * t * (1.0 - t) * (1.0 - t) * this.controlPoints[1].getX() + 3.0 * t * t * (1.0 - t) * this.controlPoints[2].getX() + t * t * t * this.controlPoints[3].getX();
            double tmpY = (1.0 - t) * (1.0 - t) * (1.0 - t) * this.controlPoints[0].getY() + 3.0 * t * (1.0 - t) * (1.0 - t) * this.controlPoints[1].getY() + 3.0 * t * t * (1.0 - t) * this.controlPoints[2].getY() + t * t * t * this.controlPoints[3].getY();
            res[i] = new Point2D.Double(tmpX, tmpY);
            ++i;
        }
        return res;
    }

    Point2D[] getCubicBezierCurve() {
        return this.curve;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Point2D[] point2DArray = this.controlPoints;
        int n = this.controlPoints.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D p = point2DArray[n2];
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(p);
            ++n2;
        }
        return "Cubic Bezier curve{control points p0, p1, p2, p3: " + sb + "}";
    }
}

