/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDTriangleBasedShadingType;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.Type5ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

public class PDShadingType5
extends PDTriangleBasedShadingType {
    public PDShadingType5(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    @Override
    public int getShadingType() {
        return 5;
    }

    public int getVerticesPerRow() {
        return this.getCOSObject().getInt(COSName.VERTICES_PER_ROW, -1);
    }

    public void setVerticesPerRow(int verticesPerRow) {
        this.getCOSObject().setInt(COSName.VERTICES_PER_ROW, verticesPerRow);
    }

    @Override
    public Paint toPaint(Matrix matrix) {
        return new Type5ShadingPaint(this, matrix);
    }

    @Override
    List<ShadedTriangle> collectTriangles(AffineTransform xform, Matrix matrix) throws IOException {
        COSDictionary dict = this.getCOSObject();
        if (!(dict instanceof COSStream)) {
            return Collections.emptyList();
        }
        PDRange rangeX = this.getDecodeForParameter(0);
        PDRange rangeY = this.getDecodeForParameter(1);
        if (Float.compare(rangeX.getMin(), rangeX.getMax()) == 0 || Float.compare(rangeY.getMin(), rangeY.getMax()) == 0) {
            return Collections.emptyList();
        }
        int numPerRow = this.getVerticesPerRow();
        PDRange[] colRange = new PDRange[this.getNumberOfColorComponents()];
        int i = 0;
        while (i < colRange.length) {
            colRange[i] = this.getDecodeForParameter(2 + i);
            ++i;
        }
        ArrayList<Vertex> vlist = new ArrayList<Vertex>();
        long maxSrcCoord = (long)Math.pow(2.0, this.getBitsPerCoordinate()) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.getBitsPerComponent()) - 1L;
        COSStream cosStream = (COSStream)dict;
        try (MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.createInputStream());){
            boolean eof = false;
            while (!eof) {
                try {
                    Vertex p = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                    vlist.add(p);
                }
                catch (EOFException eOFException) {
                    eof = true;
                }
            }
        }
        int rowNum = vlist.size() / numPerRow;
        Vertex[][] latticeArray = new Vertex[rowNum][numPerRow];
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        if (rowNum < 2) {
            return list;
        }
        int i2 = 0;
        while (i2 < rowNum) {
            int j = 0;
            while (j < numPerRow) {
                latticeArray[i2][j] = (Vertex)vlist.get(i2 * numPerRow + j);
                ++j;
            }
            ++i2;
        }
        Point2D[] ps = new Point2D[3];
        float[][] cs = new float[3][];
        int i3 = 0;
        while (i3 < rowNum - 1) {
            int j = 0;
            while (j < numPerRow - 1) {
                ps[0] = latticeArray[i3][j].point;
                ps[1] = latticeArray[i3][j + 1].point;
                ps[2] = latticeArray[i3 + 1][j].point;
                cs[0] = latticeArray[i3][j].color;
                cs[1] = latticeArray[i3][j + 1].color;
                cs[2] = latticeArray[i3 + 1][j].color;
                list.add(new ShadedTriangle(ps, cs));
                ps[0] = latticeArray[i3][j + 1].point;
                ps[1] = latticeArray[i3 + 1][j].point;
                ps[2] = latticeArray[i3 + 1][j + 1].point;
                cs[0] = latticeArray[i3][j + 1].color;
                cs[1] = latticeArray[i3 + 1][j].color;
                cs[2] = latticeArray[i3 + 1][j + 1].color;
                list.add(new ShadedTriangle(ps, cs));
                ++j;
            }
            ++i3;
        }
        return list;
    }
}

