/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public final class IterativeMergeSort {
    private IterativeMergeSort() {
    }

    public static <T> void sort(List<T> list, Comparator<? super T> cmp) {
        if (list.size() < 2) {
            return;
        }
        Object[] arr = list.toArray();
        IterativeMergeSort.iterativeMergeSort(arr, cmp);
        ListIterator<T> i = list.listIterator();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            i.next();
            i.set(e);
            ++n2;
        }
    }

    private static <T> void iterativeMergeSort(T[] arr, Comparator<? super T> cmp) {
        Object[] aux = (Object[])arr.clone();
        int blockSize = 1;
        while (blockSize < arr.length) {
            int start = 0;
            while (start < arr.length) {
                IterativeMergeSort.merge(arr, aux, start, start + blockSize, start + (blockSize << 1), cmp);
                start += blockSize << 1;
            }
            blockSize <<= 1;
        }
    }

    private static <T> void merge(T[] arr, T[] aux, int from, int mid, int to, Comparator<? super T> cmp) {
        if (mid >= arr.length) {
            return;
        }
        if (to > arr.length) {
            to = arr.length;
        }
        int i = from;
        int j = mid;
        int k = from;
        while (k < to) {
            aux[k] = i == mid ? arr[j++] : (j == to ? arr[i++] : (cmp.compare(arr[j], arr[i]) < 0 ? arr[j++] : arr[i++]));
            ++k;
        }
        System.arraycopy(aux, from, arr, from, to - from);
    }
}

