/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.filetypedetector;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.pdfbox.util.Charsets;
import org.apache.pdfbox.util.filetypedetector.ByteTrie;
import org.apache.pdfbox.util.filetypedetector.FileType;

public final class FileTypeDetector {
    private static final ByteTrie<FileType> root = new ByteTrie();

    static {
        root.setDefaultValue(FileType.UNKNOWN);
        root.addPath(FileType.JPEG, new byte[][]{{-1, -40}});
        byte[][] byArrayArray = new byte[2][];
        byArrayArray[0] = "II".getBytes(Charsets.ISO_8859_1);
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byArrayArray[1] = byArray;
        root.addPath(FileType.TIFF, byArrayArray);
        byte[][] byArrayArray2 = new byte[2][];
        byArrayArray2[0] = "MM".getBytes(Charsets.ISO_8859_1);
        byte[] byArray2 = new byte[2];
        byArray2[1] = 42;
        byArrayArray2[1] = byArray2;
        root.addPath(FileType.TIFF, byArrayArray2);
        root.addPath(FileType.PSD, new byte[][]{"8BPS".getBytes(Charsets.ISO_8859_1)});
        byte[][] byArrayArray3 = new byte[1][];
        byte[] byArray3 = new byte[16];
        byArray3[0] = -119;
        byArray3[1] = 80;
        byArray3[2] = 78;
        byArray3[3] = 71;
        byArray3[4] = 13;
        byArray3[5] = 10;
        byArray3[6] = 26;
        byArray3[7] = 10;
        byArray3[11] = 13;
        byArray3[12] = 73;
        byArray3[13] = 72;
        byArray3[14] = 68;
        byArray3[15] = 82;
        byArrayArray3[0] = byArray3;
        root.addPath(FileType.PNG, byArrayArray3);
        root.addPath(FileType.BMP, new byte[][]{"BM".getBytes(Charsets.ISO_8859_1)});
        root.addPath(FileType.GIF, new byte[][]{"GIF87a".getBytes(Charsets.ISO_8859_1)});
        root.addPath(FileType.GIF, new byte[][]{"GIF89a".getBytes(Charsets.ISO_8859_1)});
        byte[][] byArrayArray4 = new byte[1][];
        byte[] byArray4 = new byte[4];
        byArray4[2] = 1;
        byArrayArray4[0] = byArray4;
        root.addPath(FileType.ICO, byArrayArray4);
        byte[][] byArrayArray5 = new byte[1][];
        byte[] byArray5 = new byte[3];
        byArray5[0] = 10;
        byArray5[2] = 1;
        byArrayArray5[0] = byArray5;
        root.addPath(FileType.PCX, byArrayArray5);
        root.addPath(FileType.PCX, new byte[][]{{10, 2, 1}});
        root.addPath(FileType.PCX, new byte[][]{{10, 3, 1}});
        root.addPath(FileType.PCX, new byte[][]{{10, 5, 1}});
        root.addPath(FileType.RIFF, new byte[][]{"RIFF".getBytes(Charsets.ISO_8859_1)});
        byte[][] byArrayArray6 = new byte[3][];
        byArrayArray6[0] = "II".getBytes(Charsets.ISO_8859_1);
        byte[] byArray6 = new byte[4];
        byArray6[0] = 26;
        byArrayArray6[1] = byArray6;
        byArrayArray6[2] = "HEAPCCDR".getBytes(Charsets.ISO_8859_1);
        root.addPath(FileType.CRW, byArrayArray6);
        byte[][] byArrayArray7 = new byte[2][];
        byArrayArray7[0] = "II".getBytes(Charsets.ISO_8859_1);
        byte[] byArray7 = new byte[8];
        byArray7[0] = 42;
        byArray7[2] = 16;
        byArray7[6] = 67;
        byArray7[7] = 82;
        byArrayArray7[1] = byArray7;
        root.addPath(FileType.CR2, byArrayArray7);
        byte[][] byArrayArray8 = new byte[2][];
        byArrayArray8[0] = "MM".getBytes(Charsets.ISO_8859_1);
        byte[] byArray8 = new byte[7];
        byArray8[1] = 42;
        byArray8[5] = -128;
        byArrayArray8[1] = byArray8;
        root.addPath(FileType.NEF, byArrayArray8);
        byte[][] byArrayArray9 = new byte[2][];
        byArrayArray9[0] = "IIRO".getBytes(Charsets.ISO_8859_1);
        byte[] byArray9 = new byte[2];
        byArray9[0] = 8;
        byArrayArray9[1] = byArray9;
        root.addPath(FileType.ORF, byArrayArray9);
        byte[][] byArrayArray10 = new byte[2][];
        byArrayArray10[0] = "IIRS".getBytes(Charsets.ISO_8859_1);
        byte[] byArray10 = new byte[2];
        byArray10[0] = 8;
        byArrayArray10[1] = byArray10;
        root.addPath(FileType.ORF, byArrayArray10);
        root.addPath(FileType.RAF, new byte[][]{"FUJIFILMCCD-RAW".getBytes(Charsets.ISO_8859_1)});
        byte[][] byArrayArray11 = new byte[2][];
        byArrayArray11[0] = "II".getBytes(Charsets.ISO_8859_1);
        byte[] byArray11 = new byte[2];
        byArray11[0] = 85;
        byArrayArray11[1] = byArray11;
        root.addPath(FileType.RW2, byArrayArray11);
    }

    private FileTypeDetector() {
    }

    public static FileType detectFileType(BufferedInputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("Stream must support mark/reset");
        }
        int maxByteCount = root.getMaxDepth();
        inputStream.mark(maxByteCount);
        byte[] bytes = new byte[maxByteCount];
        int bytesRead = inputStream.read(bytes);
        if (bytesRead == -1) {
            throw new IOException("Stream ended before file's magic number could be determined.");
        }
        inputStream.reset();
        return root.find(bytes);
    }

    public static FileType detectFileType(byte[] fileBytes) throws IOException {
        return root.find(fileBytes);
    }
}

