/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.common.usermodel.fonts;

import org.apache.poi.common.usermodel.fonts.FontFamily;

public enum FontPitch {
    DEFAULT(0),
    FIXED(1),
    VARIABLE(2);

    private int nativeId;

    private FontPitch(int nativeId) {
        this.nativeId = nativeId;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public static byte getNativeId(FontPitch pitch, FontFamily family) {
        return (byte)(pitch.getNativeId() | family.getFlag() << 4);
    }

    public static FontPitch valueOfPitchFamily(byte pitchAndFamily) {
        return FontPitch.valueOf(pitchAndFamily & 3);
    }

    public static FontPitch valueOf(String string) {
        return Enum.valueOf(FontPitch.class, string);
    }
}

