/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.POIDocument;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HPSFPropertiesOnlyDocument
extends POIDocument {
    public HPSFPropertiesOnlyDocument(POIFSFileSystem fs) {
        super(fs);
    }

    @Override
    public void write() throws IOException {
        POIFSFileSystem fs = this.getDirectory().getFileSystem();
        this.validateInPlaceWritePossible();
        this.writeProperties(fs, null);
        fs.writeFilesystem();
    }

    @Override
    public void write(File newFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (POIFSFileSystem fs = POIFSFileSystem.create(newFile);){
            this.write(fs);
            fs.writeFilesystem();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (POIFSFileSystem fs = new POIFSFileSystem();){
            this.write(fs);
            fs.writeFilesystem(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void write(POIFSFileSystem fs) throws IOException {
        ArrayList<String> excepts = new ArrayList<String>(2);
        this.writeProperties(fs, excepts);
        FilteringDirectoryNode src = new FilteringDirectoryNode(this.getDirectory(), excepts);
        FilteringDirectoryNode dest = new FilteringDirectoryNode(fs.getRoot(), excepts);
        EntryUtils.copyNodes(src, dest);
    }
}

