/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.StringUtil;

public class BiffDrawingToXml {
    private static final String SHEET_NAME_PARAM = "-sheet-name";
    private static final String SHEET_INDEXES_PARAM = "-sheet-indexes";
    private static final String EXCLUDE_WORKBOOK_RECORDS = "-exclude-workbook";

    private static int getAttributeIndex(String attribute, String[] params) {
        int i = 0;
        while (i < params.length) {
            String param = params[i];
            if (attribute.equals(param)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isExcludeWorkbookRecords(String[] params) {
        return -1 != BiffDrawingToXml.getAttributeIndex(EXCLUDE_WORKBOOK_RECORDS, params);
    }

    private static List<Integer> getIndexesByName(String[] params, HSSFWorkbook workbook) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int pos = BiffDrawingToXml.getAttributeIndex(SHEET_NAME_PARAM, params);
        if (-1 != pos) {
            if (pos >= params.length) {
                throw new IllegalArgumentException("sheet name param value was not specified");
            }
            String sheetName = params[pos + 1];
            int sheetPos = workbook.getSheetIndex(sheetName);
            if (-1 == sheetPos) {
                throw new IllegalArgumentException("specified sheet name has not been found in xls file");
            }
            list.add(sheetPos);
        }
        return list;
    }

    private static List<Integer> getIndexesByIdArray(String[] params) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int pos = BiffDrawingToXml.getAttributeIndex(SHEET_INDEXES_PARAM, params);
        if (-1 != pos) {
            String[] sheets;
            if (pos >= params.length) {
                throw new IllegalArgumentException("sheet list value was not specified");
            }
            String sheetParam = params[pos + 1];
            String[] stringArray = sheets = sheetParam.split(",");
            int n = sheets.length;
            int n2 = 0;
            while (n2 < n) {
                String sheet = stringArray[n2];
                list.add(Integer.parseInt(sheet));
                ++n2;
            }
        }
        return list;
    }

    private static List<Integer> getSheetsIndexes(String[] params, HSSFWorkbook workbook) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.addAll(BiffDrawingToXml.getIndexesByIdArray(params));
        list.addAll(BiffDrawingToXml.getIndexesByName(params, workbook));
        if (list.size() == 0) {
            int size = workbook.getNumberOfSheets();
            int i = 0;
            while (i < size) {
                list.add(i);
                ++i;
            }
        }
        return list;
    }

    private static String getInputFileName(String[] params) {
        return params[params.length - 1];
    }

    private static String getOutputFileName(String input) {
        if (input.contains("xls")) {
            return input.replace(".xls", ".xml");
        }
        return String.valueOf(input) + ".xml";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] params) throws IOException {
        if (params.length == 0) {
            System.out.println("Usage: BiffDrawingToXml [options] inputWorkbook");
            System.out.println("Options:");
            System.out.println("  -exclude-workbook            exclude workbook-level records");
            System.out.println("  -sheet-indexes   <indexes>   output sheets with specified indexes");
            System.out.println("  -sheet-namek  <names>        output sheets with specified name");
            return;
        }
        String input = BiffDrawingToXml.getInputFileName(params);
        String output = BiffDrawingToXml.getOutputFileName(input);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileInputStream inp = new FileInputStream(input);
            try {
                try (FileOutputStream outputStream = new FileOutputStream(output);){
                    BiffDrawingToXml.writeToFile(outputStream, inp, BiffDrawingToXml.isExcludeWorkbookRecords(params), params);
                }
                if (inp == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inp == null) throw throwable;
                inp.close();
                throw throwable;
            }
            inp.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void writeToFile(OutputStream fos, InputStream xlsWorkbook, boolean excludeWorkbookRecords, String[] params) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (HSSFWorkbook workbook = new HSSFWorkbook(xlsWorkbook);){
            InternalWorkbook internalWorkbook = workbook.getInternalWorkbook();
            DrawingGroupRecord r = (DrawingGroupRecord)internalWorkbook.findFirstRecordBySid((short)235);
            StringBuilder builder = new StringBuilder();
            builder.append("<workbook>\n");
            String tab = "\t";
            if (!excludeWorkbookRecords && r != null) {
                r.decode();
                List<EscherRecord> escherRecords = r.getEscherRecords();
                for (EscherRecord record : escherRecords) {
                    builder.append(record.toXml(tab));
                }
            }
            List<Integer> sheets = BiffDrawingToXml.getSheetsIndexes(params, workbook);
            for (Integer i : sheets) {
                HSSFPatriarch p = workbook.getSheetAt(i).getDrawingPatriarch();
                if (p == null) continue;
                builder.append(tab).append("<sheet").append(i).append(">\n");
                builder.append(p.getBoundAggregate().toXml(String.valueOf(tab) + "\t"));
                builder.append(tab).append("</sheet").append(i).append(">\n");
            }
            builder.append("</workbook>\n");
            fos.write(builder.toString().getBytes(StringUtil.UTF8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

