/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.dev.BiffViewer;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EFBiffViewer {
    String file;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new File(this.file), true);
            try {
                try (InputStream din = BiffViewer.getPOIFSInputStream(fs);){
                    HSSFRequest req = new HSSFRequest();
                    req.addListenerForAllRecords(System.out::println);
                    HSSFEventFactory factory = new HSSFEventFactory();
                    factory.processEvents(req, din);
                }
                if (fs == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fs == null) throw throwable;
                fs.close();
                throw throwable;
            }
            fs.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1 && !args[0].equals("--help")) {
            EFBiffViewer viewer = new EFBiffViewer();
            viewer.setFile(args[0]);
            viewer.run();
        } else {
            System.out.println("EFBiffViewer");
            System.out.println("Outputs biffview of records based on HSSFEventFactory");
            System.out.println("usage: java org.apache.poi.hssf.dev.EBBiffViewer filename");
        }
    }
}

