/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.dev.BiffViewer;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class RecordLister {
    String file;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new File(this.file), true);
            try {
                try (InputStream din = BiffViewer.getPOIFSInputStream(fs);){
                    RecordInputStream rinp = new RecordInputStream(din);
                    while (rinp.hasNextRecord()) {
                        int sid = rinp.getNextSid();
                        rinp.nextRecord();
                        int size = rinp.available();
                        Class<? extends Record> clz = RecordFactory.getRecordClass(sid);
                        System.out.print(String.valueOf(RecordLister.formatSID(sid)) + " - " + RecordLister.formatSize(size) + " bytes");
                        if (clz != null) {
                            System.out.print("  \t");
                            System.out.print(clz.getName().replace("org.apache.poi.hssf.record.", ""));
                        }
                        System.out.println();
                        byte[] data = rinp.readRemainder();
                        if (data.length <= 0) continue;
                        System.out.print("   ");
                        System.out.println(RecordLister.formatData(data));
                    }
                }
                if (fs == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fs == null) throw throwable;
                fs.close();
                throw throwable;
            }
            fs.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static String formatSID(int sid) {
        String hex = Integer.toHexString(sid);
        String dec = Integer.toString(sid);
        StringBuilder s = new StringBuilder();
        s.append("0x");
        int i = hex.length();
        while (i < 4) {
            s.append('0');
            ++i;
        }
        s.append(hex);
        s.append(" (");
        i = dec.length();
        while (i < 4) {
            s.append('0');
            ++i;
        }
        s.append(dec);
        s.append(")");
        return s.toString();
    }

    private static String formatSize(int size) {
        String hex = Integer.toHexString(size);
        String dec = Integer.toString(size);
        StringBuilder s = new StringBuilder();
        int i = hex.length();
        while (i < 3) {
            s.append('0');
            ++i;
        }
        s.append(hex);
        s.append(" (");
        i = dec.length();
        while (i < 3) {
            s.append('0');
            ++i;
        }
        s.append(dec);
        s.append(")");
        return s.toString();
    }

    private static String formatData(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        if (data.length > 9) {
            s.append(RecordLister.byteToHex(data[0]));
            s.append(' ');
            s.append(RecordLister.byteToHex(data[1]));
            s.append(' ');
            s.append(RecordLister.byteToHex(data[2]));
            s.append(' ');
            s.append(RecordLister.byteToHex(data[3]));
            s.append(' ');
            s.append(" .... ");
            s.append(' ');
            s.append(RecordLister.byteToHex(data[data.length - 4]));
            s.append(' ');
            s.append(RecordLister.byteToHex(data[data.length - 3]));
            s.append(' ');
            s.append(RecordLister.byteToHex(data[data.length - 2]));
            s.append(' ');
            s.append(RecordLister.byteToHex(data[data.length - 1]));
        } else {
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte aData = byArray[n2];
                s.append(RecordLister.byteToHex(aData));
                s.append(' ');
                ++n2;
            }
        }
        return s.toString();
    }

    private static String byteToHex(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        String s = Integer.toHexString(i);
        if (i < 16) {
            return "0" + s;
        }
        return s;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1 && !args[0].equals("--help")) {
            RecordLister viewer = new RecordLister();
            viewer.setFile(args[0]);
            viewer.run();
        } else {
            System.out.println("RecordLister");
            System.out.println("Outputs the summary of the records in file order");
            System.out.println("usage: java org.apache.poi.hssf.dev.RecordLister filename");
        }
    }
}

