/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;

public class HSSFRequest {
    private final Map<Short, List<HSSFListener>> _records = new HashMap<Short, List<HSSFListener>>(50);

    public void addListener(HSSFListener lsnr, short sid) {
        List list = this._records.computeIfAbsent(sid, k -> new ArrayList(1));
        list.add(lsnr);
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes;
        short[] sArray = rectypes = RecordFactory.getAllKnownRecordSIDs();
        int n = rectypes.length;
        int n2 = 0;
        while (n2 < n) {
            short rectype = sArray[n2];
            this.addListener(lsnr, rectype);
            ++n2;
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        List<HSSFListener> listeners = this._records.get(rec.getSid());
        short userCode = 0;
        if (listeners != null) {
            int k = 0;
            while (k < listeners.size()) {
                HSSFListener listenObj = listeners.get(k);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode != 0) {
                        break;
                    }
                } else {
                    listener = listenObj;
                    listener.processRecord(rec);
                }
                ++k;
            }
        }
        return userCode;
    }
}

