/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndianOutput;

public final class PaletteRecord
extends StandardRecord {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private static final int[] DEFAULT_COLORS;
    private final ArrayList<PColor> _colors = new ArrayList(100);

    static {
        int[] nArray = new int[56];
        nArray[1] = 0xFFFFFF;
        nArray[2] = 0xFF0000;
        nArray[3] = 65280;
        nArray[4] = 255;
        nArray[5] = 0xFFFF00;
        nArray[6] = 0xFF00FF;
        nArray[7] = 65535;
        nArray[8] = 0x800000;
        nArray[9] = 32768;
        nArray[10] = 128;
        nArray[11] = 0x808000;
        nArray[12] = 0x800080;
        nArray[13] = 32896;
        nArray[14] = 0xC0C0C0;
        nArray[15] = 0x808080;
        nArray[16] = 0x9999FF;
        nArray[17] = 0x993366;
        nArray[18] = 0xFFFFCC;
        nArray[19] = 0xCCFFFF;
        nArray[20] = 0x660066;
        nArray[21] = 0xFF8080;
        nArray[22] = 26316;
        nArray[23] = 0xCCCCFF;
        nArray[24] = 128;
        nArray[25] = 0xFF00FF;
        nArray[26] = 0xFFFF00;
        nArray[27] = 65535;
        nArray[28] = 0x800080;
        nArray[29] = 0x800000;
        nArray[30] = 32896;
        nArray[31] = 255;
        nArray[32] = 52479;
        nArray[33] = 0xCCFFFF;
        nArray[34] = 0xCCFFCC;
        nArray[35] = 0xFFFF99;
        nArray[36] = 0x99CCFF;
        nArray[37] = 0xFF99CC;
        nArray[38] = 0xCC99FF;
        nArray[39] = 0xFFCC99;
        nArray[40] = 0x3366FF;
        nArray[41] = 0x33CCCC;
        nArray[42] = 0x99CC00;
        nArray[43] = 0xFFCC00;
        nArray[44] = 0xFF9900;
        nArray[45] = 0xFF6600;
        nArray[46] = 0x666699;
        nArray[47] = 0x969696;
        nArray[48] = 13158;
        nArray[49] = 0x339966;
        nArray[50] = 13056;
        nArray[51] = 0x333300;
        nArray[52] = 0x993300;
        nArray[53] = 0x993366;
        nArray[54] = 0x333399;
        nArray[55] = 0x333333;
        DEFAULT_COLORS = nArray;
    }

    public PaletteRecord() {
        Arrays.stream(DEFAULT_COLORS).mapToObj(PColor::new).forEach(this._colors::add);
    }

    public PaletteRecord(PaletteRecord other) {
        super(other);
        this._colors.ensureCapacity(other._colors.size());
        other._colors.stream().map(PColor::new).forEach(this._colors::add);
    }

    public PaletteRecord(RecordInputStream in) {
        int field_1_numcolors = in.readShort();
        this._colors.ensureCapacity(field_1_numcolors);
        int k = 0;
        while (k < field_1_numcolors) {
            this._colors.add(new PColor(in));
            ++k;
        }
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this._colors.size());
        for (PColor color : this._colors) {
            color.serialize(out);
        }
    }

    @Override
    protected int getDataSize() {
        return 2 + this._colors.size() * 4;
    }

    @Override
    public short getSid() {
        return 146;
    }

    public byte[] getColor(int byteIndex) {
        int i = byteIndex - 8;
        if (i < 0 || i >= this._colors.size()) {
            return null;
        }
        return this._colors.get(i).getTriplet();
    }

    /*
     * Unable to fully structure code
     */
    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        i = byteIndex - 8;
        if (i >= 0 && i < 56) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this._colors.add(new PColor(0, 0, 0));
lbl6:
            // 2 sources

            ** while (this._colors.size() <= i)
        }
lbl7:
        // 1 sources

        custColor = new PColor(red, green, blue);
        this._colors.set(i, custColor);
    }

    @Override
    public PaletteRecord copy() {
        return new PaletteRecord(this);
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.PALETTE;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("colors", () -> this._colors);
    }

    private static final class PColor
    implements GenericRecord {
        public static final short ENCODED_SIZE = 4;
        private final int _red;
        private final int _green;
        private final int _blue;

        PColor(int rgb) {
            this._red = rgb >>> 16 & 0xFF;
            this._green = rgb >>> 8 & 0xFF;
            this._blue = rgb & 0xFF;
        }

        PColor(int red, int green, int blue) {
            this._red = red;
            this._green = green;
            this._blue = blue;
        }

        PColor(PColor other) {
            this._red = other._red;
            this._green = other._green;
            this._blue = other._blue;
        }

        PColor(RecordInputStream in) {
            this._red = in.readByte();
            this._green = in.readByte();
            this._blue = in.readByte();
            in.readByte();
        }

        byte[] getTriplet() {
            return new byte[]{(byte)this._red, (byte)this._green, (byte)this._blue};
        }

        void serialize(LittleEndianOutput out) {
            out.writeByte(this._red);
            out.writeByte(this._green);
            out.writeByte(this._blue);
            out.writeByte(0);
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties("red", () -> this._red & 0xFF, "green", () -> this._green & 0xFF, "blue", () -> this._blue & 0xFF);
        }
    }
}

