/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.cont;

import java.io.IOException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;

public abstract class ContinuableRecord
extends Record {
    protected ContinuableRecord() {
    }

    protected ContinuableRecord(ContinuableRecord other) {
        super(other);
    }

    protected abstract void serialize(ContinuableRecordOutput var1);

    @Override
    public final int getRecordSize() {
        ContinuableRecordOutput out = ContinuableRecordOutput.createForCountingOnly();
        this.serialize(out);
        out.terminate();
        return out.getTotalSize();
    }

    @Override
    public final int serialize(int offset, byte[] data) {
        int totalSize = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (LittleEndianByteArrayOutputStream leo = new LittleEndianByteArrayOutputStream(data, offset);){
                ContinuableRecordOutput out = new ContinuableRecordOutput(leo, this.getSid());
                this.serialize(out);
                out.terminate();
                totalSize = out.getTotalSize();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return totalSize;
    }
}

