/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.HashSet;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class HSSFOptimiser {
    public static void optimiseFonts(HSSFWorkbook workbook) {
        short[] newPos = new short[workbook.getWorkbook().getNumberOfFontRecords() + 1];
        boolean[] zapRecords = new boolean[newPos.length];
        int i = 0;
        while (i < newPos.length) {
            newPos[i] = (short)i;
            zapRecords[i] = false;
            ++i;
        }
        FontRecord[] frecs = new FontRecord[newPos.length];
        int i2 = 0;
        while (i2 < newPos.length) {
            if (i2 != 4) {
                frecs[i2] = workbook.getWorkbook().getFontRecordAt(i2);
            }
            ++i2;
        }
        i2 = 5;
        while (i2 < newPos.length) {
            int earlierDuplicate = -1;
            int j = 0;
            while (j < i2 && earlierDuplicate == -1) {
                FontRecord frCheck;
                if (j != 4 && (frCheck = workbook.getWorkbook().getFontRecordAt(j)).sameProperties(frecs[i2])) {
                    earlierDuplicate = j;
                }
                ++j;
            }
            if (earlierDuplicate != -1) {
                newPos[i2] = (short)earlierDuplicate;
                zapRecords[i2] = true;
            }
            ++i2;
        }
        i2 = 5;
        while (i2 < newPos.length) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i2];
            int j = 0;
            while (j < preDeletePos) {
                if (zapRecords[j]) {
                    newPosition = (short)(newPosition - 1);
                }
                ++j;
            }
            newPos[i2] = newPosition;
            ++i2;
        }
        i2 = 5;
        while (i2 < newPos.length) {
            if (zapRecords[i2]) {
                workbook.getWorkbook().removeFontRecord(frecs[i2]);
            }
            ++i2;
        }
        workbook.resetFontCache();
        i2 = 0;
        while (i2 < workbook.getWorkbook().getNumExFormats()) {
            ExtendedFormatRecord xfr = workbook.getWorkbook().getExFormatAt(i2);
            xfr.setFontIndex(newPos[xfr.getFontIndex()]);
            ++i2;
        }
        HashSet<UnicodeString> doneUnicodeStrings = new HashSet<UnicodeString>();
        int sheetNum = 0;
        while (sheetNum < workbook.getNumberOfSheets()) {
            HSSFSheet s = workbook.getSheetAt(sheetNum);
            for (Row row : s) {
                for (Cell cell : row) {
                    HSSFRichTextString rtr;
                    UnicodeString u;
                    if (cell.getCellType() != CellType.STRING || doneUnicodeStrings.contains(u = (rtr = (HSSFRichTextString)cell.getRichStringCellValue()).getRawUnicodeString())) continue;
                    short i3 = 5;
                    while (i3 < newPos.length) {
                        if (i3 != newPos[i3]) {
                            u.swapFontUse(i3, newPos[i3]);
                        }
                        i3 = (short)(i3 + 1);
                    }
                    doneUnicodeStrings.add(u);
                }
            }
            ++sheetNum;
        }
    }

    public static void optimiseCellStyles(HSSFWorkbook workbook) {
        short[] newPos = new short[workbook.getWorkbook().getNumExFormats()];
        boolean[] isUsed = new boolean[newPos.length];
        boolean[] zapRecords = new boolean[newPos.length];
        boolean[] userDefined = new boolean[newPos.length];
        ExtendedFormatRecord[] xfrs = new ExtendedFormatRecord[newPos.length];
        int i = 0;
        while (i < newPos.length) {
            isUsed[i] = false;
            newPos[i] = (short)i;
            zapRecords[i] = false;
            userDefined[i] = HSSFOptimiser.isUserDefined(workbook, i);
            xfrs[i] = workbook.getWorkbook().getExFormatAt(i);
            ++i;
        }
        i = 21;
        while (i < newPos.length) {
            int earlierDuplicate = -1;
            int j = 0;
            while (j < i) {
                ExtendedFormatRecord xfCheck = workbook.getWorkbook().getExFormatAt(j);
                if (xfCheck.equals(xfrs[i]) && !userDefined[j]) {
                    earlierDuplicate = j;
                    break;
                }
                ++j;
            }
            if (earlierDuplicate != -1) {
                newPos[i] = (short)earlierDuplicate;
                zapRecords[i] = true;
            }
            ++i;
        }
        int sheetNum = 0;
        while (sheetNum < workbook.getNumberOfSheets()) {
            HSSFSheet s = workbook.getSheetAt(sheetNum);
            for (Row row : s) {
                for (Cell cellI : row) {
                    HSSFCell cell = (HSSFCell)cellI;
                    short oldXf = cell.getCellValueRecord().getXFIndex();
                    if (oldXf >= newPos.length) continue;
                    isUsed[oldXf] = true;
                }
                short oldXf = ((HSSFRow)row).getRowRecord().getXFIndex();
                if (oldXf >= newPos.length) continue;
                isUsed[oldXf] = true;
            }
            int col = s.getSheet().getMinColumnIndex();
            while (col <= s.getSheet().getMaxColumnIndex()) {
                short oldXf = s.getSheet().getXFIndexForColAt((short)col);
                if (oldXf < newPos.length) {
                    isUsed[oldXf] = true;
                }
                ++col;
            }
            ++sheetNum;
        }
        i = 21;
        while (i < isUsed.length) {
            if (HSSFOptimiser.isUserDefined(workbook, i)) {
                isUsed[i] = true;
            }
            if (newPos[i] != i && isUsed[i]) {
                isUsed[newPos[i]] = true;
            }
            ++i;
        }
        i = 21;
        while (i < isUsed.length) {
            if (!isUsed[i]) {
                zapRecords[i] = true;
                newPos[i] = 0;
            }
            ++i;
        }
        i = 21;
        while (i < newPos.length) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i];
            int j = 0;
            while (j < preDeletePos) {
                if (zapRecords[j]) {
                    newPosition = (short)(newPosition - 1);
                }
                ++j;
            }
            newPos[i] = newPosition;
            if (i != newPosition && newPosition != 0) {
                workbook.getWorkbook().updateStyleRecord(i, newPosition);
                ExtendedFormatRecord exFormat = workbook.getWorkbook().getExFormatAt(i);
                short oldParent = exFormat.getParentIndex();
                if (oldParent < newPos.length) {
                    short newParent = newPos[oldParent];
                    exFormat.setParentIndex(newParent);
                }
            }
            ++i;
        }
        int max = newPos.length;
        int removed = 0;
        int i2 = 21;
        while (i2 < max) {
            if (zapRecords[i2 + removed]) {
                workbook.getWorkbook().removeExFormatRecord(i2);
                --i2;
                --max;
                ++removed;
            }
            ++i2;
        }
        int sheetNum2 = 0;
        while (sheetNum2 < workbook.getNumberOfSheets()) {
            HSSFSheet s = workbook.getSheetAt(sheetNum2);
            for (Row row : s) {
                for (Cell cell : row) {
                    short oldXf = ((HSSFCell)cell).getCellValueRecord().getXFIndex();
                    if (oldXf >= newPos.length) continue;
                    HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                    cell.setCellStyle(newStyle);
                }
                short oldXf = ((HSSFRow)row).getRowRecord().getXFIndex();
                if (oldXf >= newPos.length) continue;
                HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                row.setRowStyle(newStyle);
            }
            int col = s.getSheet().getMinColumnIndex();
            while (col <= s.getSheet().getMaxColumnIndex()) {
                short oldXf = s.getSheet().getXFIndexForColAt((short)col);
                if (oldXf < newPos.length) {
                    HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                    s.setDefaultColumnStyle(col, newStyle);
                }
                ++col;
            }
            ++sheetNum2;
        }
    }

    private static boolean isUserDefined(HSSFWorkbook workbook, int index) {
        StyleRecord styleRecord = workbook.getWorkbook().getStyleRecord(index);
        return styleRecord != null && !styleRecord.isBuiltin() && styleRecord.getName() != null;
    }
}

