/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import org.apache.poi.EncryptedDocumentException;

public enum CipherProvider {
    rc4("RC4", 1, "Microsoft Base Cryptographic Provider v1.0"),
    aes("AES", 24, "Microsoft Enhanced RSA and AES Cryptographic Provider");

    public final String jceId;
    public final int ecmaId;
    public final String cipherProviderName;

    public static CipherProvider fromEcmaId(int ecmaId) {
        CipherProvider[] cipherProviderArray = CipherProvider.values();
        int n = cipherProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CipherProvider cp = cipherProviderArray[n2];
            if (cp.ecmaId == ecmaId) {
                return cp;
            }
            ++n2;
        }
        throw new EncryptedDocumentException("cipher provider not found");
    }

    private CipherProvider(String jceId, int ecmaId, String cipherProviderName) {
        this.jceId = jceId;
        this.ecmaId = ecmaId;
        this.cipherProviderName = cipherProviderName;
    }
}

