/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class POIFSLister {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        boolean withSizes = false;
        boolean newPOIFS = true;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equalsIgnoreCase("-size") || arg.equalsIgnoreCase("-sizes")) {
                withSizes = true;
            } else if (arg.equalsIgnoreCase("-old") || arg.equalsIgnoreCase("-old-poifs")) {
                newPOIFS = false;
            } else if (newPOIFS) {
                POIFSLister.viewFile(arg, withSizes);
            } else {
                POIFSLister.viewFileOld(arg, withSizes);
            }
            ++n2;
        }
    }

    public static void viewFile(String filename, boolean withSizes) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (POIFSFileSystem fs = new POIFSFileSystem(new File(filename));){
            POIFSLister.displayDirectory(fs.getRoot(), "", withSizes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void viewFileOld(String filename, boolean withSizes) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            try {
                try (POIFSFileSystem fs = new POIFSFileSystem(fis);){
                    POIFSLister.displayDirectory(fs.getRoot(), "", withSizes);
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void displayDirectory(DirectoryNode dir, String indent, boolean withSizes) {
        System.out.println(String.valueOf(indent) + dir.getName() + " -");
        String newIndent = String.valueOf(indent) + "  ";
        boolean hadChildren = false;
        Iterator<Entry> it = dir.getEntries();
        while (it.hasNext()) {
            hadChildren = true;
            Entry entry = it.next();
            if (entry instanceof DirectoryNode) {
                POIFSLister.displayDirectory((DirectoryNode)entry, newIndent, withSizes);
                continue;
            }
            DocumentNode doc = (DocumentNode)entry;
            String name = doc.getName();
            String size = "";
            if (name.charAt(0) < '\n') {
                String altname = "(0x0" + name.charAt(0) + ")" + name.substring(1);
                name = String.valueOf(name.substring(1)) + " <" + altname + ">";
            }
            if (withSizes) {
                size = " [" + doc.getSize() + " / 0x" + Integer.toHexString(doc.getSize()) + "]";
            }
            System.out.println(String.valueOf(newIndent) + name + size);
        }
        if (!hadChildren) {
            System.out.println(String.valueOf(newIndent) + "(no children)");
        }
    }
}

