/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LocaleUtil;

public final class FileMagic
extends Enum<FileMagic> {
    public static final /* enum */ FileMagic OLE2 = new FileMagic(-2226271756974174256L);
    public static final /* enum */ FileMagic OOXML = new FileMagic(80, 75, 3, 4);
    public static final /* enum */ FileMagic XML = new FileMagic(60, 63, 120, 109, 108);
    public static final /* enum */ FileMagic BIFF2 = new FileMagic(9, 0, 4, 0, 0, 0, 63, 0);
    public static final /* enum */ FileMagic BIFF3 = new FileMagic(9, 2, 6, 0, 0, 0, 63, 0);
    public static final /* enum */ FileMagic BIFF4;
    public static final /* enum */ FileMagic MSWRITE;
    public static final /* enum */ FileMagic RTF;
    public static final /* enum */ FileMagic PDF;
    public static final /* enum */ FileMagic HTML;
    public static final /* enum */ FileMagic WORD2;
    public static final /* enum */ FileMagic JPEG;
    public static final /* enum */ FileMagic GIF;
    public static final /* enum */ FileMagic PNG;
    public static final /* enum */ FileMagic TIFF;
    public static final /* enum */ FileMagic WMF;
    public static final /* enum */ FileMagic EMF;
    public static final /* enum */ FileMagic BMP;
    public static final /* enum */ FileMagic UNKNOWN;
    static final int MAX_PATTERN_LENGTH = 44;
    final byte[][] magic;
    private static final /* synthetic */ FileMagic[] ENUM$VALUES;

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[8];
        byArray[0] = 9;
        byArray[1] = 4;
        byArray[2] = 6;
        byArray[6] = 63;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 9;
        byArray2[1] = 4;
        byArray2[2] = 6;
        byArray2[7] = 1;
        byArrayArray[1] = byArray2;
        BIFF4 = new FileMagic(byArrayArray);
        byte[][] byArrayArray2 = new byte[2][];
        byte[] byArray3 = new byte[4];
        byArray3[0] = 49;
        byArray3[1] = -66;
        byArrayArray2[0] = byArray3;
        byte[] byArray4 = new byte[4];
        byArray4[0] = 50;
        byArray4[1] = -66;
        byArrayArray2[1] = byArray4;
        MSWRITE = new FileMagic(byArrayArray2);
        RTF = new FileMagic("{\\rtf");
        PDF = new FileMagic("%PDF");
        HTML = new FileMagic("<!DOCTYP", "<html", "\n\r<html", "\r\n<html", "\r<html", "\n<html", "<HTML", "\r\n<HTML", "\n\r<HTML", "\r<HTML", "\n<HTML");
        WORD2 = new FileMagic(219, 165, 45, 0);
        byte[][] byArrayArray3 = new byte[4][];
        byArrayArray3[0] = new byte[]{-1, -40, -1, -37};
        byte[] byArray5 = new byte[12];
        byArray5[0] = -1;
        byArray5[1] = -40;
        byArray5[2] = -1;
        byArray5[3] = -32;
        byArray5[4] = 63;
        byArray5[5] = 63;
        byArray5[6] = 74;
        byArray5[7] = 70;
        byArray5[8] = 73;
        byArray5[9] = 70;
        byArray5[11] = 1;
        byArrayArray3[1] = byArray5;
        byArrayArray3[2] = new byte[]{-1, -40, -1, -18};
        byte[] byArray6 = new byte[12];
        byArray6[0] = -1;
        byArray6[1] = -40;
        byArray6[2] = -1;
        byArray6[3] = -31;
        byArray6[4] = 63;
        byArray6[5] = 63;
        byArray6[6] = 69;
        byArray6[7] = 120;
        byArray6[8] = 105;
        byArray6[9] = 102;
        byArrayArray3[3] = byArray6;
        JPEG = new FileMagic(byArrayArray3);
        GIF = new FileMagic("GIF87a", "GIF89a");
        PNG = new FileMagic(137, 80, 78, 71, 13, 10, 26, 10);
        TIFF = new FileMagic("II*\u0000", "MM\u0000*");
        WMF = new FileMagic(215, 205, 198, 154);
        EMF = new FileMagic(1, 0, 0, 0, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 32, 69, 77, 70);
        BMP = new FileMagic(66, 77);
        UNKNOWN = new FileMagic(new byte[][]{new byte[0]});
        ENUM$VALUES = new FileMagic[]{OLE2, OOXML, XML, BIFF2, BIFF3, BIFF4, MSWRITE, RTF, PDF, HTML, WORD2, JPEG, GIF, PNG, TIFF, WMF, EMF, BMP, UNKNOWN};
    }

    private FileMagic(long magic) {
        this.magic = new byte[1][8];
        LittleEndian.putLong(this.magic[0], 0, magic);
    }

    private FileMagic(int ... magic) {
        byte[] one = new byte[magic.length];
        int i = 0;
        while (i < magic.length) {
            one[i] = (byte)(magic[i] & 0xFF);
            ++i;
        }
        this.magic = new byte[][]{one};
    }

    private FileMagic(byte[] ... magic) {
        this.magic = magic;
    }

    private FileMagic(String ... magic) {
        this.magic = new byte[magic.length][];
        int i = 0;
        String[] stringArray = magic;
        int n2 = magic.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            this.magic[i++] = s.getBytes(LocaleUtil.CHARSET_1252);
            ++n3;
        }
    }

    public static FileMagic valueOf(byte[] magic) {
        FileMagic[] fileMagicArray = FileMagic.values();
        int n = fileMagicArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileMagic fm = fileMagicArray[n2];
            byte[][] byArray = fm.magic;
            int n3 = fm.magic.length;
            int n4 = 0;
            while (n4 < n3) {
                byte[] ma = byArray[n4];
                if (magic.length >= ma.length && FileMagic.findMagic(ma, magic)) {
                    return fm;
                }
                ++n4;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private static boolean findMagic(byte[] expected, byte[] actual) {
        int i = 0;
        byte[] byArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            byte expectedByte = byArray[n2];
            if (actual[i++] != expectedByte && expectedByte != 63) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static FileMagic valueOf(File inp) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fis = new FileInputStream(inp);){
            byte[] data = new byte[44];
            int read = IOUtils.readFully(fis, data, 0, 44);
            if (read == -1) {
                return UNKNOWN;
            }
            data = Arrays.copyOf(data, read);
            return FileMagic.valueOf(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static FileMagic valueOf(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            throw new IOException("getFileMagic() only operates on streams which support mark(int)");
        }
        byte[] data = IOUtils.peekFirstNBytes(inp, 44);
        return FileMagic.valueOf(data);
    }

    public static InputStream prepareToCheckMagic(InputStream stream) {
        if (stream.markSupported()) {
            return stream;
        }
        return new BufferedInputStream(stream);
    }

    public static FileMagic[] values() {
        FileMagic[] fileMagicArray = ENUM$VALUES;
        int n = fileMagicArray.length;
        FileMagic[] fileMagicArray2 = new FileMagic[n];
        System.arraycopy(ENUM$VALUES, 0, fileMagicArray2, 0, n);
        return fileMagicArray2;
    }

    public static FileMagic valueOf(String string) {
        return Enum.valueOf(FileMagic.class, string);
    }
}

