/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.macros;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.poifs.macros.VBAMacroReader;
import org.apache.poi.util.StringUtil;

public class VBAMacroExtractor {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   VBAMacroExtractor <office.doc> [output]");
            System.err.println();
            System.err.println("If an output directory is given, macros are written there");
            System.err.println("Otherwise they are output to the screen");
            System.exit(1);
        }
        File input = new File(args[0]);
        File output = null;
        if (args.length > 1) {
            output = new File(args[1]);
        }
        VBAMacroExtractor extractor = new VBAMacroExtractor();
        extractor.extract(input, output);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(File input, File outputDir, String extension) throws IOException {
        Map<String, String> macros;
        if (!input.exists()) {
            throw new FileNotFoundException(input.toString());
        }
        System.err.print("Extracting VBA Macros from " + input + " to ");
        if (outputDir != null) {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IOException("Output directory " + outputDir + " could not be created");
            }
            System.err.println(outputDir);
        } else {
            System.err.println("STDOUT");
        }
        Throwable throwable = null;
        Iterator<Map.Entry<String, String>> iterator = null;
        try (VBAMacroReader reader = new VBAMacroReader(input);){
            macros = reader.readMacros();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
        iterator = macros.entrySet().iterator();
        while (true) {
            File out;
            block28: {
                if (!iterator.hasNext()) {
                    if (outputDir != null) return;
                    System.out.println("---------------------------------------");
                    return;
                }
                Map.Entry<String, String> entry = iterator.next();
                String moduleName = entry.getKey();
                String moduleCode = entry.getValue();
                if (outputDir == null) {
                    System.out.println("---------------------------------------");
                    System.out.println(moduleName);
                    System.out.println();
                    System.out.println(moduleCode);
                    continue;
                }
                out = new File(outputDir, String.valueOf(moduleName) + extension);
                Throwable throwable3 = null;
                Object var11_14 = null;
                try {
                    FileOutputStream fout = new FileOutputStream(out);
                    try {
                        try (OutputStreamWriter fwriter = new OutputStreamWriter((OutputStream)fout, StringUtil.UTF8);){
                            fwriter.write(moduleCode);
                        }
                        if (fout == null) break block28;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        if (fout == null) throw throwable3;
                        fout.close();
                        throw throwable3;
                    }
                    fout.close();
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                        throw throwable3;
                    }
                    if (throwable3 == throwable5) throw throwable3;
                    throwable3.addSuppressed(throwable5);
                    throw throwable3;
                }
            }
            System.out.println("Extracted " + out);
        }
    }

    public void extract(File input, File outputDir) throws IOException {
        this.extract(input, outputDir, ".vba");
    }
}

