/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

public interface LineDecoration {
    public DecorationShape getHeadShape();

    public DecorationSize getHeadWidth();

    public DecorationSize getHeadLength();

    public DecorationShape getTailShape();

    public DecorationSize getTailWidth();

    public DecorationSize getTailLength();

    public static enum DecorationShape {
        NONE(0, 1),
        TRIANGLE(1, 2),
        STEALTH(2, 3),
        DIAMOND(3, 4),
        OVAL(4, 5),
        ARROW(5, 6);

        public final int nativeId;
        public final int ooxmlId;

        private DecorationShape(int nativeId, int ooxmlId) {
            this.nativeId = nativeId;
            this.ooxmlId = ooxmlId;
        }

        public static DecorationShape fromNativeId(int nativeId) {
            DecorationShape[] decorationShapeArray = DecorationShape.values();
            int n = decorationShapeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DecorationShape ld = decorationShapeArray[n2];
                if (ld.nativeId == nativeId) {
                    return ld;
                }
                ++n2;
            }
            return null;
        }

        public static DecorationShape fromOoxmlId(int ooxmlId) {
            DecorationShape[] decorationShapeArray = DecorationShape.values();
            int n = decorationShapeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DecorationShape ds = decorationShapeArray[n2];
                if (ds.ooxmlId == ooxmlId) {
                    return ds;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum DecorationSize {
        SMALL(0, 1),
        MEDIUM(1, 2),
        LARGE(2, 3);

        public final int nativeId;
        public final int ooxmlId;

        private DecorationSize(int nativeId, int ooxmlId) {
            this.nativeId = nativeId;
            this.ooxmlId = ooxmlId;
        }

        public static DecorationSize fromNativeId(int nativeId) {
            DecorationSize[] decorationSizeArray = DecorationSize.values();
            int n = decorationSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DecorationSize ld = decorationSizeArray[n2];
                if (ld.nativeId == nativeId) {
                    return ld;
                }
                ++n2;
            }
            return null;
        }

        public static DecorationSize fromOoxmlId(int ooxmlId) {
            DecorationSize[] decorationSizeArray = DecorationSize.values();
            int n = decorationSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DecorationSize ds = decorationSizeArray[n2];
                if (ds.ooxmlId == ooxmlId) {
                    return ds;
                }
                ++n2;
            }
            return null;
        }
    }
}

