/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;

public interface ObjectData {
    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    default public byte[] getBytes() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.getInputStream();){
            return IOUtils.toByteArray(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public boolean hasDirectoryEntry() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = FileMagic.prepareToCheckMagic(this.getInputStream());){
                FileMagic fm = FileMagic.valueOf(is);
                boolean bl = fm == FileMagic.OLE2;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger LOG = LogManager.getLogger(ObjectData.class);
            LOG.atWarn().withThrowable((Throwable)e).log("Can't determine filemagic of ole stream");
            return false;
        }
    }

    default public DirectoryEntry getDirectory() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.getInputStream();){
            return new POIFSFileSystem(is).getRoot();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getOLE2ClassName();

    public String getFileName();
}

