/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.usermodel.ObjectData;
import org.apache.poi.sl.usermodel.ObjectMetaData;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.util.IOUtils;

public interface ObjectShape<S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>>
extends Shape<S, P>,
PlaceableShape<S, P> {
    public PictureData getPictureData();

    public String getProgId();

    public String getFullName();

    public OutputStream updateObjectData(ObjectMetaData.Application var1, ObjectMetaData var2) throws IOException;

    /*
     * Loose catch block
     */
    default public InputStream readObjectData() throws IOException {
        String progId = this.getProgId();
        if (progId == null) {
            throw new IllegalStateException("Ole object hasn't been initialized or provided in the source xml. use updateObjectData() first or check the corresponding slideXXX.xml");
        }
        ObjectMetaData.Application app = ObjectMetaData.Application.lookup(progId);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream;
            InputStream is;
            UnsynchronizedByteArrayOutputStream bos;
            block40: {
                block39: {
                    block38: {
                        bos = new UnsynchronizedByteArrayOutputStream();
                        is = FileMagic.prepareToCheckMagic(this.readObjectDataRaw());
                        FileMagic fm = FileMagic.valueOf(is);
                        if (fm == FileMagic.OLE2) {
                            Throwable throwable2 = null;
                            Object var9_13 = null;
                            try (POIFSFileSystem poifs = new POIFSFileSystem(is);){
                                String[] names = new String[]{app == null ? null : app.getMetaData().getOleEntry(), "Package", "Contents", "CONTENTS", "CONTENTSV30"};
                                DirectoryNode root = poifs.getRoot();
                                String entryName = null;
                                String[] stringArray = names;
                                int n = names.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String n3 = stringArray[n2];
                                    if (root.hasEntry(n3)) {
                                        entryName = n3;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (entryName == null) {
                                    poifs.writeFilesystem((OutputStream)bos);
                                    break block38;
                                }
                                Throwable throwable3 = null;
                                Object var15_23 = null;
                                try (DocumentInputStream is2 = poifs.createDocumentInputStream(entryName);){
                                    IOUtils.copy((InputStream)is2, (OutputStream)bos);
                                    break block38;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        IOUtils.copy(is, (OutputStream)bos);
                    }
                    inputStream = bos.toInputStream();
                    if (is == null) break block39;
                    is.close();
                }
                if (bos == null) break block40;
                bos.close();
            }
            return inputStream;
            {
                catch (Throwable throwable6) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            throwable = throwable7;
                        } else if (throwable != throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        if (bos != null) {
                            bos.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
    }

    default public InputStream readObjectDataRaw() throws IOException {
        return this.getObjectData().getInputStream();
    }

    public ObjectData getObjectData();
}

