/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import org.apache.poi.sl.usermodel.PaintStyle;

public interface StrokeStyle {
    public PaintStyle getPaint();

    public LineCap getLineCap();

    public LineDash getLineDash();

    public LineCompound getLineCompound();

    public double getLineWidth();

    public static enum LineCap {
        ROUND(0, 1),
        SQUARE(1, 2),
        FLAT(2, 3);

        public final int nativeId;
        public final int ooxmlId;

        private LineCap(int nativeId, int ooxmlId) {
            this.nativeId = nativeId;
            this.ooxmlId = ooxmlId;
        }

        public static LineCap fromNativeId(int nativeId) {
            LineCap[] lineCapArray = LineCap.values();
            int n = lineCapArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineCap ld = lineCapArray[n2];
                if (ld.nativeId == nativeId) {
                    return ld;
                }
                ++n2;
            }
            return null;
        }

        public static LineCap fromOoxmlId(int ooxmlId) {
            LineCap[] lineCapArray = LineCap.values();
            int n = lineCapArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineCap lc = lineCapArray[n2];
                if (lc.ooxmlId == ooxmlId) {
                    return lc;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum LineCompound {
        SINGLE(0, 1),
        DOUBLE(1, 2),
        THICK_THIN(2, 3),
        THIN_THICK(3, 4),
        TRIPLE(4, 5);

        public final int nativeId;
        public final int ooxmlId;

        private LineCompound(int nativeId, int ooxmlId) {
            this.nativeId = nativeId;
            this.ooxmlId = ooxmlId;
        }

        public static LineCompound fromNativeId(int nativeId) {
            LineCompound[] lineCompoundArray = LineCompound.values();
            int n = lineCompoundArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineCompound lc = lineCompoundArray[n2];
                if (lc.nativeId == nativeId) {
                    return lc;
                }
                ++n2;
            }
            return null;
        }

        public static LineCompound fromOoxmlId(int ooxmlId) {
            LineCompound[] lineCompoundArray = LineCompound.values();
            int n = lineCompoundArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineCompound lc = lineCompoundArray[n2];
                if (lc.ooxmlId == ooxmlId) {
                    return lc;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum LineDash {
        SOLID(1, 1, null),
        DOT(6, 2, 1, 1),
        DASH(7, 3, 3, 4),
        DASH_DOT(9, 5, 4, 3, 1, 3),
        LG_DASH(8, 4, 8, 3),
        LG_DASH_DOT(10, 6, 8, 3, 1, 3),
        LG_DASH_DOT_DOT(11, 7, 8, 3, 1, 3, 1, 3),
        SYS_DASH(2, 8, 2, 2),
        SYS_DOT(3, 9, 1, 1),
        SYS_DASH_DOT(4, 10, 2, 2, 1, 1),
        SYS_DASH_DOT_DOT(5, 11, 2, 2, 1, 1, 1, 1);

        public final int[] pattern;
        public final int nativeId;
        public final int ooxmlId;

        private LineDash(int nativeId, int ooxmlId, int ... pattern) {
            this.nativeId = nativeId;
            this.ooxmlId = ooxmlId;
            this.pattern = pattern == null || pattern.length == 0 ? null : pattern;
        }

        public static LineDash fromNativeId(int nativeId) {
            LineDash[] lineDashArray = LineDash.values();
            int n = lineDashArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineDash ld = lineDashArray[n2];
                if (ld.nativeId == nativeId) {
                    return ld;
                }
                ++n2;
            }
            return null;
        }

        public static LineDash fromOoxmlId(int ooxmlId) {
            LineDash[] lineDashArray = LineDash.values();
            int n = lineDashArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineDash ld = lineDashArray[n2];
                if (ld.ooxmlId == ooxmlId) {
                    return ld;
                }
                ++n2;
            }
            return null;
        }
    }
}

