/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.ClassIDPredefined;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.extractor.EmbeddedData;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.ObjectData;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Shape;
import org.apache.poi.ss.usermodel.ShapeContainer;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.StringUtil;

public class EmbeddedExtractor
implements Iterable<EmbeddedExtractor> {
    private static final Logger LOG = LogManager.getLogger(EmbeddedExtractor.class);
    private static final int DEFAULT_MAX_RECORD_LENGTH = 1000000;
    private static int MAX_RECORD_LENGTH = 1000000;
    private static final String CONTENT_TYPE_BYTES = "binary/octet-stream";
    private static final String CONTENT_TYPE_PDF = "application/pdf";
    private static final String CONTENT_TYPE_DOC = "application/msword";
    private static final String CONTENT_TYPE_XLS = "application/vnd.ms-excel";

    public static void setMaxRecordLength(int length) {
        MAX_RECORD_LENGTH = length;
    }

    public static int getMaxRecordLength() {
        return MAX_RECORD_LENGTH;
    }

    @Override
    public Iterator<EmbeddedExtractor> iterator() {
        EmbeddedExtractor[] ee = new EmbeddedExtractor[]{new Ole10Extractor(), new PdfExtractor(), new BiffExtractor(), new OOXMLExtractor(), new FsExtractor()};
        return Arrays.asList(ee).iterator();
    }

    public EmbeddedData extractOne(DirectoryNode src) throws IOException {
        for (EmbeddedExtractor ee : this) {
            if (!ee.canExtract(src)) continue;
            return ee.extract(src);
        }
        return null;
    }

    public EmbeddedData extractOne(Picture src) throws IOException {
        for (EmbeddedExtractor ee : this) {
            if (!ee.canExtract(src)) continue;
            return ee.extract(src);
        }
        return null;
    }

    public List<EmbeddedData> extractAll(Sheet sheet) throws IOException {
        Drawing<?> patriarch = sheet.getDrawingPatriarch();
        if (patriarch == null) {
            return Collections.emptyList();
        }
        ArrayList<EmbeddedData> embeddings = new ArrayList<EmbeddedData>();
        this.extractAll(patriarch, embeddings);
        return embeddings;
    }

    protected void extractAll(ShapeContainer<?> parent, List<EmbeddedData> embeddings) throws IOException {
        for (Shape shape : parent) {
            String extension;
            EmbeddedData data;
            block11: {
                data = null;
                if (shape instanceof ObjectData) {
                    ObjectData od = (ObjectData)shape;
                    try {
                        if (od.hasDirectoryEntry()) {
                            data = this.extractOne((DirectoryNode)od.getDirectory());
                            break block11;
                        }
                        data = new EmbeddedData(od.getFileName(), od.getObjectData(), od.getContentType());
                    }
                    catch (Exception e) {
                        LOG.atWarn().withThrowable((Throwable)e).log("Entry not found / readable - ignoring OLE embedding");
                    }
                } else if (shape instanceof Picture) {
                    data = this.extractOne((Picture)shape);
                } else if (shape instanceof ShapeContainer) {
                    this.extractAll((ShapeContainer)((Object)shape), embeddings);
                }
            }
            if (data == null) continue;
            data.setShape(shape);
            String filename = data.getFilename();
            String string = extension = filename == null || filename.lastIndexOf(46) == -1 ? ".bin" : filename.substring(filename.lastIndexOf(46));
            if ((filename == null || filename.isEmpty() || filename.startsWith("MBD") || filename.startsWith("Root Entry")) && (filename = shape.getShapeName()) != null) {
                filename = String.valueOf(filename) + extension;
            }
            if (filename == null || filename.isEmpty()) {
                filename = "picture_" + embeddings.size() + extension;
            }
            filename = filename.trim();
            data.setFilename(filename);
            embeddings.add(data);
        }
    }

    public boolean canExtract(DirectoryNode source) {
        return false;
    }

    public boolean canExtract(Picture source) {
        return false;
    }

    /*
     * Loose catch block
     */
    protected EmbeddedData extract(DirectoryNode dn) throws IOException {
        assert (this.canExtract(dn));
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            EmbeddedData embeddedData;
            POIFSFileSystem dest;
            UnsynchronizedByteArrayOutputStream bos;
            block17: {
                block16: {
                    bos = new UnsynchronizedByteArrayOutputStream(20000);
                    dest = new POIFSFileSystem();
                    EmbeddedExtractor.copyNodes(dn, dest.getRoot());
                    dest.writeFilesystem((OutputStream)bos);
                    embeddedData = new EmbeddedData(dn.getName(), bos.toByteArray(), CONTENT_TYPE_BYTES);
                    if (dest == null) break block16;
                    dest.close();
                }
                if (bos == null) break block17;
                bos.close();
            }
            return embeddedData;
            {
                catch (Throwable throwable2) {
                    try {
                        if (dest != null) {
                            dest.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (bos != null) {
                            bos.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected EmbeddedData extract(Picture source) throws IOException {
        return null;
    }

    protected static void copyNodes(DirectoryNode src, DirectoryNode dest) throws IOException {
        for (Entry e : src) {
            if (e instanceof DirectoryNode) {
                DirectoryNode srcDir = (DirectoryNode)e;
                DirectoryNode destDir = (DirectoryNode)dest.createDirectory(srcDir.getName());
                destDir.setStorageClsid(srcDir.getStorageClsid());
                EmbeddedExtractor.copyNodes(srcDir, destDir);
                continue;
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (DocumentInputStream is = src.createDocumentInputStream(e);){
                dest.createDocument(e.getName(), is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int indexOf(byte[] data, int offset, byte[] pattern) {
        failure = EmbeddedExtractor.computeFailure(pattern);
        j = 0;
        if (data.length == 0) {
            return -1;
        }
        i = offset;
        ** GOTO lbl15
        {
            j = failure[j - 1];
            do {
                if (j > 0 && pattern[j] != data[i]) continue block0;
                if (pattern[j] == data[i]) {
                    ++j;
                }
                if (j == pattern.length) {
                    return i - pattern.length + 1;
                }
                ++i;
lbl15:
                // 2 sources

            } while (i < data.length);
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int[] computeFailure(byte[] pattern) {
        failure = new int[pattern.length];
        j = 0;
        i = 1;
        ** GOTO lbl12
        {
            j = failure[j - 1];
            do {
                if (j > 0 && pattern[j] != pattern[i]) continue block0;
                if (pattern[j] == pattern[i]) {
                    // empty if block
                }
                failure[i] = ++j;
                ++i;
lbl12:
                // 2 sources

            } while (i < pattern.length);
        }
        return failure;
    }

    static class BiffExtractor
    extends EmbeddedExtractor {
        BiffExtractor() {
        }

        @Override
        public boolean canExtract(DirectoryNode dn) {
            return this.canExtractExcel(dn) || this.canExtractWord(dn);
        }

        protected boolean canExtractExcel(DirectoryNode dn) {
            ClassIDPredefined clsId = ClassIDPredefined.lookup(dn.getStorageClsid());
            return ClassIDPredefined.EXCEL_V7 == clsId || ClassIDPredefined.EXCEL_V8 == clsId || dn.hasEntry("Workbook");
        }

        protected boolean canExtractWord(DirectoryNode dn) {
            ClassIDPredefined clsId = ClassIDPredefined.lookup(dn.getStorageClsid());
            return ClassIDPredefined.WORD_V7 == clsId || ClassIDPredefined.WORD_V8 == clsId || dn.hasEntry("WordDocument");
        }

        @Override
        public EmbeddedData extract(DirectoryNode dn) throws IOException {
            EmbeddedData ed = super.extract(dn);
            if (this.canExtractExcel(dn)) {
                ed.setFilename(String.valueOf(dn.getName()) + ".xls");
                ed.setContentType(EmbeddedExtractor.CONTENT_TYPE_XLS);
            } else if (this.canExtractWord(dn)) {
                ed.setFilename(String.valueOf(dn.getName()) + ".doc");
                ed.setContentType(EmbeddedExtractor.CONTENT_TYPE_DOC);
            }
            return ed;
        }
    }

    static class FsExtractor
    extends EmbeddedExtractor {
        FsExtractor() {
        }

        @Override
        public boolean canExtract(DirectoryNode dn) {
            return true;
        }

        @Override
        public EmbeddedData extract(DirectoryNode dn) throws IOException {
            EmbeddedData ed = super.extract(dn);
            ed.setFilename(String.valueOf(dn.getName()) + ".ole");
            return ed;
        }
    }

    static class OOXMLExtractor
    extends EmbeddedExtractor {
        OOXMLExtractor() {
        }

        @Override
        public boolean canExtract(DirectoryNode dn) {
            return dn.hasEntry("package");
        }

        @Override
        public EmbeddedData extract(DirectoryNode dn) throws IOException {
            ClassIDPredefined clsId = ClassIDPredefined.lookup(dn.getStorageClsid());
            String contentType = null;
            String ext = null;
            if (clsId != null) {
                contentType = clsId.getContentType();
                ext = clsId.getFileExtension();
            }
            if (contentType == null || ext == null) {
                contentType = "application/zip";
                ext = ".zip";
            }
            DocumentInputStream dis = dn.createDocumentInputStream("package");
            byte[] data = IOUtils.toByteArray(dis);
            dis.close();
            return new EmbeddedData(String.valueOf(dn.getName()) + ext, data, contentType);
        }
    }

    public static class Ole10Extractor
    extends EmbeddedExtractor {
        @Override
        public boolean canExtract(DirectoryNode dn) {
            ClassID clsId = dn.getStorageClsid();
            return ClassIDPredefined.lookup(clsId) == ClassIDPredefined.OLE_V1_PACKAGE;
        }

        @Override
        public EmbeddedData extract(DirectoryNode dn) throws IOException {
            try {
                Ole10Native ole10 = Ole10Native.createFromEmbeddedOleObject(dn);
                return new EmbeddedData(ole10.getFileName(), ole10.getDataBuffer(), EmbeddedExtractor.CONTENT_TYPE_BYTES);
            }
            catch (Ole10NativeException e) {
                throw new IOException(e);
            }
        }
    }

    static class PdfExtractor
    extends EmbeddedExtractor {
        PdfExtractor() {
        }

        @Override
        public boolean canExtract(DirectoryNode dn) {
            ClassID clsId = dn.getStorageClsid();
            return ClassIDPredefined.PDF.equals(clsId) || dn.hasEntry("CONTENTS");
        }

        /*
         * Loose catch block
         */
        @Override
        public EmbeddedData extract(DirectoryNode dn) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                EmbeddedData embeddedData;
                DocumentInputStream is;
                UnsynchronizedByteArrayOutputStream bos;
                block16: {
                    block15: {
                        bos = new UnsynchronizedByteArrayOutputStream();
                        is = dn.createDocumentInputStream("CONTENTS");
                        IOUtils.copy((InputStream)is, (OutputStream)bos);
                        embeddedData = new EmbeddedData(String.valueOf(dn.getName()) + ".pdf", bos.toByteArray(), EmbeddedExtractor.CONTENT_TYPE_PDF);
                        if (is == null) break block15;
                        ((InputStream)is).close();
                    }
                    if (bos == null) break block16;
                    bos.close();
                }
                return embeddedData;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (bos != null) {
                                bos.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }

        @Override
        public boolean canExtract(Picture source) {
            PictureData pd = source.getPictureData();
            return pd != null && pd.getPictureType() == 2;
        }

        @Override
        protected EmbeddedData extract(Picture source) throws IOException {
            PictureData pd = source.getPictureData();
            if (pd == null || pd.getPictureType() != 2) {
                return null;
            }
            byte[] pictureBytes = pd.getData();
            int idxStart = EmbeddedExtractor.indexOf(pictureBytes, 0, "%PDF-".getBytes(LocaleUtil.CHARSET_1252));
            if (idxStart == -1) {
                return null;
            }
            int idxEnd = EmbeddedExtractor.indexOf(pictureBytes, idxStart, "%%EOF".getBytes(LocaleUtil.CHARSET_1252));
            if (idxEnd == -1) {
                return null;
            }
            int pictureBytesLen = idxEnd - idxStart + 6;
            byte[] pdfBytes = IOUtils.safelyClone(pictureBytes, idxStart, pictureBytesLen, MAX_RECORD_LENGTH);
            String filename = source.getShapeName().trim();
            if (!StringUtil.endsWithIgnoreCase(filename, ".pdf")) {
                filename = String.valueOf(filename) + ".pdf";
            }
            return new EmbeddedData(filename, pdfBytes, EmbeddedExtractor.CONTENT_TYPE_PDF);
        }
    }
}

