/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.util.Locale;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;

public class CellTextFormatter
extends CellFormatter {
    private final int[] textPos;
    private final String desc;
    static final CellFormatter SIMPLE_TEXT = new CellTextFormatter("@");

    public CellTextFormatter(String format) {
        super(format);
        int[] numPlaces = new int[1];
        this.desc = CellFormatPart.parseFormat(format, CellFormatType.TEXT, (m, part, type, desc) -> {
            if (part.equals("@")) {
                nArray[0] = numPlaces[0] + 1;
                return "\u0000";
            }
            return null;
        }).toString();
        this.textPos = new int[numPlaces[0]];
        int pos = this.desc.length() - 1;
        int i = 0;
        while (i < this.textPos.length) {
            this.textPos[i] = this.desc.lastIndexOf(0, pos);
            pos = this.textPos[i] - 1;
            ++i;
        }
    }

    @Override
    public void formatValue(StringBuffer toAppendTo, Object obj) {
        int start = toAppendTo.length();
        String text = obj.toString();
        if (obj instanceof Boolean) {
            text = text.toUpperCase(Locale.ROOT);
        }
        toAppendTo.append(this.desc);
        int[] nArray = this.textPos;
        int n = this.textPos.length;
        int n2 = 0;
        while (n2 < n) {
            int textPo = nArray[n2];
            int pos = start + textPo;
            toAppendTo.replace(pos, pos + 1, text);
            ++n2;
        }
    }

    @Override
    public void simpleValue(StringBuffer toAppendTo, Object value) {
        SIMPLE_TEXT.formatValue(toAppendTo, value);
    }
}

