/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.formula.CellCacheEntry;
import org.apache.poi.ss.formula.FormulaUsedBlankCellSet;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.eval.ValueEval;

final class FormulaCellCacheEntry
extends CellCacheEntry {
    private CellCacheEntry[] _sensitiveInputCells;
    private FormulaUsedBlankCellSet _usedBlankCellGroup;

    public boolean isInputSensitive() {
        if (this._sensitiveInputCells != null && this._sensitiveInputCells.length > 0) {
            return true;
        }
        return this._usedBlankCellGroup == null ? false : !this._usedBlankCellGroup.isEmpty();
    }

    public void setSensitiveInputCells(CellCacheEntry[] sensitiveInputCells) {
        if (sensitiveInputCells == null) {
            this._sensitiveInputCells = null;
            this.changeConsumingCells(CellCacheEntry.EMPTY_ARRAY);
        } else {
            this._sensitiveInputCells = (CellCacheEntry[])sensitiveInputCells.clone();
            this.changeConsumingCells(this._sensitiveInputCells);
        }
    }

    public void clearFormulaEntry() {
        CellCacheEntry[] usedCells = this._sensitiveInputCells;
        if (usedCells != null) {
            int i = usedCells.length - 1;
            while (i >= 0) {
                usedCells[i].clearConsumingCell(this);
                --i;
            }
        }
        this._sensitiveInputCells = null;
        this.clearValue();
    }

    private void changeConsumingCells(CellCacheEntry[] usedCells) {
        Set usedSet;
        CellCacheEntry[] prevUsedCells = this._sensitiveInputCells;
        int nUsed = usedCells.length;
        int i = 0;
        while (i < nUsed) {
            usedCells[i].addConsumingCell(this);
            ++i;
        }
        if (prevUsedCells == null) {
            return;
        }
        int nPrevUsed = prevUsedCells.length;
        if (nPrevUsed < 1) {
            return;
        }
        if (nUsed < 1) {
            usedSet = Collections.emptySet();
        } else {
            usedSet = new HashSet(nUsed * 3 / 2);
            usedSet.addAll(Arrays.asList(usedCells).subList(0, nUsed));
        }
        int i2 = 0;
        while (i2 < nPrevUsed) {
            CellCacheEntry prevUsed = prevUsedCells[i2];
            if (!usedSet.contains(prevUsed)) {
                prevUsed.clearConsumingCell(this);
            }
            ++i2;
        }
    }

    public void updateFormulaResult(ValueEval result, CellCacheEntry[] sensitiveInputCells, FormulaUsedBlankCellSet usedBlankAreas) {
        this.updateValue(result);
        this.setSensitiveInputCells(sensitiveInputCells);
        this._usedBlankCellGroup = usedBlankAreas;
    }

    public void notifyUpdatedBlankCell(FormulaUsedBlankCellSet.BookSheetKey bsk, int rowIndex, int columnIndex, IEvaluationListener evaluationListener) {
        if (this._usedBlankCellGroup != null && this._usedBlankCellGroup.containsCell(bsk, rowIndex, columnIndex)) {
            this.clearFormulaEntry();
            this.recurseClearCachedFormulaResults(evaluationListener);
        }
    }
}

