/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Stack;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.MemAreaPtg;
import org.apache.poi.ss.formula.ptg.MemErrPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.util.Internal;

@Internal
public class FormulaRenderer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toFormulaString(FormulaRenderingWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        Ptg[] ptgArray = ptgs;
        int n = ptgs.length;
        int n2 = 0;
        while (n2 < n) {
            Ptg ptg = ptgArray[n2];
            if (!(ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg)) {
                if (ptg instanceof ParenthesisPtg) {
                    String contents = (String)stack.pop();
                    stack.push("(" + contents + ")");
                } else if (ptg instanceof AttrPtg) {
                    AttrPtg attrPtg = (AttrPtg)ptg;
                    if (!(attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isSkip() || attrPtg.isSpace() || attrPtg.isSemiVolatile())) {
                        if (!attrPtg.isSum()) throw new RuntimeException("Unexpected tAttr: " + attrPtg);
                        operands = FormulaRenderer.getOperands(stack, attrPtg.getNumberOfOperands());
                        stack.push(attrPtg.toFormulaString(operands));
                    }
                } else if (ptg instanceof WorkbookDependentFormula) {
                    WorkbookDependentFormula optg = (WorkbookDependentFormula)((Object)ptg);
                    stack.push(optg.toFormulaString(book));
                } else if (!(ptg instanceof OperationPtg)) {
                    stack.push(ptg.toFormulaString());
                } else {
                    OperationPtg o = (OperationPtg)ptg;
                    operands = FormulaRenderer.getOperands(stack, o.getNumberOfOperands());
                    stack.push(o.toFormulaString(operands));
                }
            }
            ++n2;
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (stack.isEmpty()) return result;
        throw new IllegalStateException("too much stuff left on the stack");
    }

    private static String[] getOperands(Stack<String> stack, int nOperands) {
        String[] operands = new String[nOperands];
        int j = nOperands - 1;
        while (j >= 0) {
            if (stack.isEmpty()) {
                String msg = "Too few arguments supplied to operation. Expected (" + nOperands + ") operands but got (" + (nOperands - j - 1) + ")";
                throw new IllegalStateException(msg);
            }
            operands[j] = stack.pop();
            --j;
        }
        return operands;
    }
}

