/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ParseNode;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.ControlPtg;
import org.apache.poi.ss.formula.ptg.FuncVarPtg;
import org.apache.poi.ss.formula.ptg.IntersectionPtg;
import org.apache.poi.ss.formula.ptg.MemAreaPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RangePtg;
import org.apache.poi.ss.formula.ptg.UnionPtg;
import org.apache.poi.ss.formula.ptg.ValueOperatorPtg;

final class OperandClassTransformer {
    private final FormulaType _formulaType;

    public OperandClassTransformer(FormulaType formulaType) {
        this._formulaType = formulaType;
    }

    public void transformFormula(ParseNode rootNode) {
        this.transformNode(rootNode, switch (this._formulaType) {
            case FormulaType.CELL -> 32;
            case FormulaType.ARRAY -> 64;
            case FormulaType.NAMEDRANGE, FormulaType.DATAVALIDATION_LIST -> 0;
            default -> throw new RuntimeException("Incomplete code - formula type (" + (Object)((Object)this._formulaType) + ") not supported yet");
        }, false);
    }

    private void transformNode(ParseNode node, byte desiredOperandClass, boolean callerForceArrayFlag) {
        Ptg token = node.getToken();
        ParseNode[] children = node.getChildren();
        boolean isSimpleValueFunc = OperandClassTransformer.isSimpleValueFunction(token);
        if (isSimpleValueFunc) {
            boolean localForceArray = desiredOperandClass == 64;
            ParseNode[] parseNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ParseNode child = parseNodeArray[n2];
                this.transformNode(child, desiredOperandClass, localForceArray);
                ++n2;
            }
            this.setSimpleValueFuncClass((AbstractFunctionPtg)token, desiredOperandClass, callerForceArrayFlag);
            return;
        }
        if (OperandClassTransformer.isSingleArgSum(token)) {
            token = FuncVarPtg.SUM;
        }
        if (token instanceof ValueOperatorPtg || token instanceof ControlPtg || token instanceof MemFuncPtg || token instanceof MemAreaPtg || token instanceof UnionPtg || token instanceof IntersectionPtg) {
            byte localDesiredOperandClass = desiredOperandClass == 0 ? (byte)32 : (byte)desiredOperandClass;
            ParseNode[] parseNodeArray = children;
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                ParseNode child = parseNodeArray[n3];
                this.transformNode(child, localDesiredOperandClass, callerForceArrayFlag);
                ++n3;
            }
            return;
        }
        if (token instanceof AbstractFunctionPtg) {
            this.transformFunctionNode((AbstractFunctionPtg)token, children, desiredOperandClass, callerForceArrayFlag);
            return;
        }
        if (children.length > 0) {
            if (token == RangePtg.instance) {
                return;
            }
            throw new IllegalStateException("Node should not have any children");
        }
        if (token.isBaseToken()) {
            return;
        }
        token.setClass(this.transformClass(token.getPtgClass(), desiredOperandClass, callerForceArrayFlag));
    }

    private static boolean isSingleArgSum(Ptg token) {
        if (token instanceof AttrPtg) {
            AttrPtg attrPtg = (AttrPtg)token;
            return attrPtg.isSum();
        }
        return false;
    }

    private static boolean isSimpleValueFunction(Ptg token) {
        if (token instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg aptg = (AbstractFunctionPtg)token;
            if (aptg.getDefaultOperandClass() != 32) {
                return false;
            }
            int numberOfOperands = aptg.getNumberOfOperands();
            int i = numberOfOperands - 1;
            while (i >= 0) {
                if (aptg.getParameterClass(i) != 32) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    private byte transformClass(byte currentOperandClass, byte desiredOperandClass, boolean callerForceArrayFlag) {
        switch (desiredOperandClass) {
            case 32: {
                if (!callerForceArrayFlag) {
                    return 32;
                }
            }
            case 64: {
                return 64;
            }
            case 0: {
                if (!callerForceArrayFlag) {
                    return currentOperandClass;
                }
                return 0;
            }
        }
        throw new IllegalStateException("Unexpected operand class (" + desiredOperandClass + ")");
    }

    private void transformFunctionNode(AbstractFunctionPtg afp, ParseNode[] children, byte desiredOperandClass, boolean callerForceArrayFlag) {
        boolean localForceArrayFlag;
        block24: {
            byte defaultReturnOperandClass;
            block23: {
                defaultReturnOperandClass = afp.getDefaultOperandClass();
                if (!callerForceArrayFlag) break block23;
                switch (defaultReturnOperandClass) {
                    case 0: {
                        if (desiredOperandClass == 0) {
                            afp.setClass((byte)0);
                        } else {
                            afp.setClass((byte)64);
                        }
                        localForceArrayFlag = false;
                        break block24;
                    }
                    case 64: {
                        afp.setClass((byte)64);
                        localForceArrayFlag = false;
                        break block24;
                    }
                    case 32: {
                        afp.setClass((byte)64);
                        localForceArrayFlag = true;
                        break block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                    }
                }
            }
            if (defaultReturnOperandClass == desiredOperandClass) {
                localForceArrayFlag = false;
                afp.setClass(defaultReturnOperandClass);
            } else {
                switch (desiredOperandClass) {
                    case 32: {
                        afp.setClass((byte)32);
                        localForceArrayFlag = false;
                        break;
                    }
                    case 64: {
                        switch (defaultReturnOperandClass) {
                            case 0: {
                                afp.setClass((byte)0);
                                break;
                            }
                            case 32: {
                                afp.setClass((byte)64);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                            }
                        }
                        localForceArrayFlag = defaultReturnOperandClass == 32;
                        break;
                    }
                    case 0: {
                        switch (defaultReturnOperandClass) {
                            case 64: {
                                afp.setClass((byte)64);
                                break;
                            }
                            case 32: {
                                afp.setClass((byte)32);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                            }
                        }
                        localForceArrayFlag = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + desiredOperandClass + ")");
                    }
                }
            }
        }
        int i = 0;
        while (i < children.length) {
            ParseNode child = children[i];
            byte paramOperandClass = afp.getParameterClass(i);
            this.transformNode(child, paramOperandClass, localForceArrayFlag);
            ++i;
        }
    }

    private void setSimpleValueFuncClass(AbstractFunctionPtg afp, byte desiredOperandClass, boolean callerForceArrayFlag) {
        if (callerForceArrayFlag || desiredOperandClass == 64) {
            afp.setClass((byte)64);
        } else {
            afp.setClass((byte)32);
        }
    }
}

