/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.atp;

import java.time.LocalDate;
import java.util.ArrayList;
import org.apache.poi.ss.formula.eval.AreaEvalBase;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.DateParser;

final class ArgumentsEvaluator {
    public static final ArgumentsEvaluator instance = new ArgumentsEvaluator();

    private ArgumentsEvaluator() {
    }

    public double evaluateDateArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, (short)srcCellCol);
        if (ve instanceof StringEval) {
            String strVal = ((StringEval)ve).getStringValue();
            Double dVal = OperandResolver.parseDouble(strVal);
            if (dVal != null) {
                return dVal;
            }
            LocalDate date = DateParser.parseLocalDate(strVal);
            return DateUtil.getExcelDate(date, false);
        }
        return OperandResolver.coerceValueToDouble(ve);
    }

    public double[] evaluateDatesArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        if (arg == null) {
            return new double[0];
        }
        if (arg instanceof StringEval) {
            return new double[]{this.evaluateDateArg(arg, srcCellRow, srcCellCol)};
        }
        if (arg instanceof AreaEvalBase) {
            ArrayList<Double> valuesList = new ArrayList<Double>();
            AreaEvalBase area = (AreaEvalBase)arg;
            int i = area.getFirstRow();
            while (i <= area.getLastRow()) {
                int j = area.getFirstColumn();
                while (j <= area.getLastColumn()) {
                    valuesList.add(this.evaluateDateArg(area.getAbsoluteValue(i, j), i, j));
                    ++j;
                }
                ++i;
            }
            double[] values = new double[valuesList.size()];
            int i2 = 0;
            while (i2 < valuesList.size()) {
                values[i2] = (Double)valuesList.get(i2);
                ++i2;
            }
            return values;
        }
        return new double[]{OperandResolver.coerceValueToDouble(arg)};
    }

    public double evaluateNumberArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        if (arg == null) {
            return 0.0;
        }
        return OperandResolver.coerceValueToDouble(arg);
    }
}

