/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.atp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.atp.ArgumentsEvaluator;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

final class TextJoinFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new TextJoinFunction(ArgumentsEvaluator.instance);
    private ArgumentsEvaluator evaluator;

    private TextJoinFunction(ArgumentsEvaluator anEvaluator) {
        this.evaluator = anEvaluator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length < 3 || args.length > 254) {
            return ErrorEval.VALUE_INVALID;
        }
        int srcRowIndex = ec.getRowIndex();
        int srcColumnIndex = ec.getColumnIndex();
        try {
            void var11_17;
            List<ValueEval> delimiterArgs = this.getValues(args[0], srcRowIndex, srcColumnIndex, true);
            ValueEval ignoreEmptyArg = OperandResolver.getSingleValue(args[1], srcRowIndex, srcColumnIndex);
            boolean ignoreEmpty = OperandResolver.coerceValueToBoolean(ignoreEmptyArg, false);
            ArrayList<String> textValues = new ArrayList<String>();
            int i = 2;
            while (i < args.length) {
                List<ValueEval> textArgs = this.getValues(args[i], srcRowIndex, srcColumnIndex, false);
                for (ValueEval valueEval : textArgs) {
                    String textValue = OperandResolver.coerceValueToString(valueEval);
                    if (ignoreEmpty && (textValue == null || textValue.length() <= 0)) continue;
                    textValues.add(textValue);
                }
                ++i;
            }
            if (delimiterArgs.size() == 0) {
                return new StringEval(String.join((CharSequence)"", textValues));
            }
            if (delimiterArgs.size() == 1) {
                String delimiter = this.laxValueToString(delimiterArgs.get(0));
                return new StringEval(String.join((CharSequence)delimiter, textValues));
            }
            ArrayList<String> delimiters = new ArrayList<String>();
            for (ValueEval delimiterArg : delimiterArgs) {
                delimiters.add(this.laxValueToString(delimiterArg));
            }
            StringBuilder sb = new StringBuilder();
            boolean bl = false;
            while (var11_17 < textValues.size()) {
                if (var11_17 > 0) {
                    void delimiterIndex = (var11_17 - true) % delimiters.size();
                    sb.append((String)delimiters.get((int)delimiterIndex));
                }
                sb.append((String)textValues.get((int)var11_17));
                ++var11_17;
            }
            return new StringEval(sb.toString());
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private String laxValueToString(ValueEval eval) {
        return eval instanceof MissingArgEval ? "" : OperandResolver.coerceValueToString(eval);
    }

    private List<ValueEval> getValues(ValueEval eval, int srcRowIndex, int srcColumnIndex, boolean lastRowOnly) throws EvaluationException {
        if (eval instanceof AreaEval) {
            int startRow;
            AreaEval ae = (AreaEval)eval;
            ArrayList<ValueEval> list = new ArrayList<ValueEval>();
            int r = startRow = lastRowOnly ? ae.getLastRow() : ae.getFirstRow();
            while (r <= ae.getLastRow()) {
                int c = ae.getFirstColumn();
                while (c <= ae.getLastColumn()) {
                    list.add(OperandResolver.getSingleValue(ae.getAbsoluteValue(r, c), r, c));
                    ++c;
                }
                ++r;
            }
            return list;
        }
        return Collections.singletonList(OperandResolver.getSingleValue(eval, srcRowIndex, srcColumnIndex));
    }
}

