/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.ThreeDEval;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;

final class CountUtils {
    private CountUtils() {
    }

    public static int countMatchingCellsInArea(ThreeDEval areaEval, I_MatchPredicate criteriaPredicate) {
        int result = 0;
        int firstSheetIndex = areaEval.getFirstSheetIndex();
        int lastSheetIndex = areaEval.getLastSheetIndex();
        int sIx = firstSheetIndex;
        while (sIx <= lastSheetIndex) {
            int height = areaEval.getHeight();
            int width = areaEval.getWidth();
            int rrIx = 0;
            while (rrIx < height) {
                int rcIx = 0;
                while (rcIx < width) {
                    I_MatchAreaPredicate areaPredicate;
                    ValueEval ve = areaEval.getValue(sIx, rrIx, rcIx);
                    if ((!(criteriaPredicate instanceof I_MatchAreaPredicate) || (areaPredicate = (I_MatchAreaPredicate)criteriaPredicate).matches(areaEval, rrIx, rcIx)) && criteriaPredicate.matches(ve)) {
                        ++result;
                    }
                    ++rcIx;
                }
                ++rrIx;
            }
            ++sIx;
        }
        return result;
    }

    public static int countMatchingCellsInRef(RefEval refEval, I_MatchPredicate criteriaPredicate) {
        int result = 0;
        int firstSheetIndex = refEval.getFirstSheetIndex();
        int lastSheetIndex = refEval.getLastSheetIndex();
        int sIx = firstSheetIndex;
        while (sIx <= lastSheetIndex) {
            ValueEval ve = refEval.getInnerValueEval(sIx);
            if (criteriaPredicate.matches(ve)) {
                ++result;
            }
            ++sIx;
        }
        return result;
    }

    public static int countArg(ValueEval eval, I_MatchPredicate criteriaPredicate) {
        if (eval == null) {
            throw new IllegalArgumentException("eval must not be null");
        }
        if (eval instanceof ThreeDEval) {
            return CountUtils.countMatchingCellsInArea((ThreeDEval)eval, criteriaPredicate);
        }
        if (eval instanceof TwoDEval) {
            throw new IllegalArgumentException("Count requires 3D Evals, 2D ones aren't supported");
        }
        if (eval instanceof RefEval) {
            return CountUtils.countMatchingCellsInRef((RefEval)eval, criteriaPredicate);
        }
        return criteriaPredicate.matches(eval) ? 1 : 0;
    }

    public static interface I_MatchAreaPredicate
    extends I_MatchPredicate {
        public boolean matches(TwoDEval var1, int var2, int var3);
    }

    public static interface I_MatchPredicate {
        public boolean matches(ValueEval var1);
    }
}

