/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.poi.ss.util.NumberToTextConverter;

final class MathX {
    private MathX() {
    }

    public static double round(double n, int p) {
        return MathX.round(n, p, RoundingMode.HALF_UP);
    }

    public static double round(double n, double p) {
        return MathX.round(n, (int)p);
    }

    public static double roundUp(double n, int p) {
        return MathX.round(n, p, RoundingMode.UP);
    }

    public static double roundUp(double n, double p) {
        return MathX.roundUp(n, (int)p);
    }

    public static double roundDown(double n, int p) {
        return MathX.round(n, p, RoundingMode.DOWN);
    }

    public static double roundDown(double n, double p) {
        return MathX.roundDown(n, (int)p);
    }

    private static double round(double n, int p, RoundingMode rounding) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        String excelNumber = NumberToTextConverter.toText(n);
        return new BigDecimal(excelNumber).setScale(p, rounding).doubleValue();
    }

    public static short sign(double d) {
        return (short)(d == 0.0 ? 0 : (d < 0.0 ? -1 : 1));
    }

    public static double average(double[] values) {
        double ave = 0.0;
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        ave = sum / (double)values.length;
        return ave;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        return sum;
    }

    public static double sumsq(double[] values) {
        double sumsq = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sumsq += value * value;
            ++n2;
        }
        return sumsq;
    }

    public static double product(double[] values) {
        double product = 0.0;
        if (values != null && values.length > 0) {
            product = 1.0;
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                product *= value;
                ++n2;
            }
        }
        return product;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            min = Math.min(min, value);
            ++n2;
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            max = Math.max(max, value);
            ++n2;
        }
        return max;
    }

    public static double floor(double n, double s) {
        if (s == 0.0 && n != 0.0) {
            return Double.NaN;
        }
        return n == 0.0 || s == 0.0 ? 0.0 : Math.floor(n / s) * s;
    }

    public static double ceiling(double n, double s) {
        if (n > 0.0 && s < 0.0) {
            return Double.NaN;
        }
        return n == 0.0 || s == 0.0 ? 0.0 : Math.ceil(n / s) * s;
    }

    public static double factorial(int n) {
        double d = 1.0;
        if (n >= 0) {
            if (n <= 170) {
                int i = 1;
                while (i <= n) {
                    d *= (double)i;
                    ++i;
                }
            } else {
                d = Double.POSITIVE_INFINITY;
            }
        } else {
            d = Double.NaN;
        }
        return d;
    }

    public static double factorial(double d) {
        return MathX.factorial((int)d);
    }

    public static double mod(double n, double d) {
        if (d == 0.0) {
            return Double.NaN;
        }
        if (MathX.sign(n) == MathX.sign(d)) {
            return n % d;
        }
        return (n % d + d) % d;
    }

    public static double acosh(double d) {
        return Math.log(Math.sqrt(Math.pow(d, 2.0) - 1.0) + d);
    }

    public static double asinh(double d) {
        return Math.log(Math.sqrt(d * d + 1.0) + d);
    }

    public static double atanh(double d) {
        return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
    }

    public static double cosh(double d) {
        double ePowX = Math.pow(Math.E, d);
        double ePowNegX = Math.pow(Math.E, -d);
        return (ePowX + ePowNegX) / 2.0;
    }

    public static double sinh(double d) {
        double ePowX = Math.pow(Math.E, d);
        double ePowNegX = Math.pow(Math.E, -d);
        return (ePowX - ePowNegX) / 2.0;
    }

    public static double tanh(double d) {
        double ePowX = Math.pow(Math.E, d);
        double ePowNegX = Math.pow(Math.E, -d);
        return (ePowX - ePowNegX) / (ePowX + ePowNegX);
    }

    public static double nChooseK(int n, int k) {
        double d = 1.0;
        if (n < 0 || k < 0 || n < k) {
            d = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n - k, k);
            int i = maxnk = Math.max(n - k, k);
            while (i < n) {
                d *= (double)(i + 1);
                ++i;
            }
            d /= MathX.factorial(minnk);
        }
        return d;
    }
}

