/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Arrays;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.functions.MultiOperandNumericFunction;

public class Mirr
extends MultiOperandNumericFunction {
    public Mirr() {
        super(false, false);
    }

    @Override
    protected int getMaxNumOperands() {
        return 3;
    }

    @Override
    protected double evaluate(double[] values) throws EvaluationException {
        double financeRate = values[values.length - 1];
        double reinvestRate = values[values.length - 2];
        double[] mirrValues = Arrays.copyOf(values, values.length - 2);
        boolean mirrValuesAreAllNegatives = true;
        double[] dArray = mirrValues;
        int n = mirrValues.length;
        int n2 = 0;
        while (n2 < n) {
            double mirrValue = dArray[n2];
            mirrValuesAreAllNegatives &= mirrValue < 0.0;
            ++n2;
        }
        if (mirrValuesAreAllNegatives) {
            return -1.0;
        }
        boolean mirrValuesAreAllPositives = true;
        double[] dArray2 = mirrValues;
        int n3 = mirrValues.length;
        n = 0;
        while (n < n3) {
            double mirrValue = dArray2[n];
            mirrValuesAreAllPositives &= mirrValue > 0.0;
            ++n;
        }
        if (mirrValuesAreAllPositives) {
            throw new EvaluationException(ErrorEval.DIV_ZERO);
        }
        return Mirr.mirr(mirrValues, financeRate, reinvestRate);
    }

    private static double mirr(double[] in, double financeRate, double reinvestRate) {
        double anIn;
        double value = 0.0;
        double numOfYears = (double)in.length - 1.0;
        double pv = 0.0;
        double fv = 0.0;
        int indexN = 0;
        double[] dArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            anIn = dArray[n2];
            if (anIn < 0.0) {
                pv += anIn / Math.pow(1.0 + financeRate + reinvestRate, indexN++);
            }
            ++n2;
        }
        dArray = in;
        n = in.length;
        n2 = 0;
        while (n2 < n) {
            anIn = dArray[n2];
            if (anIn > 0.0) {
                fv += anIn * Math.pow(1.0 + financeRate, numOfYears - (double)indexN++);
            }
            ++n2;
        }
        if (fv != 0.0 && pv != 0.0) {
            value = Math.pow(-fv / pv, 1.0 / numOfYears) - 1.0;
        }
        return value;
    }
}

