/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;

public final class Mode
implements Function {
    public static double evaluate(double[] v) throws EvaluationException {
        if (v.length < 2) {
            throw new EvaluationException(ErrorEval.NA);
        }
        int[] counts = new int[v.length];
        Arrays.fill(counts, 1);
        int i = 0;
        int iSize = v.length;
        while (i < iSize) {
            int j = i + 1;
            int jSize = v.length;
            while (j < jSize) {
                if (v[i] == v[j]) {
                    int n = i;
                    counts[n] = counts[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        double maxv = 0.0;
        int maxc = 0;
        int i2 = 0;
        int iSize2 = counts.length;
        while (i2 < iSize2) {
            if (counts[i2] > maxc) {
                maxv = v[i2];
                maxc = counts[i2];
            }
            ++i2;
        }
        if (maxc > 1) {
            return maxv;
        }
        throw new EvaluationException(ErrorEval.NA);
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcCellRow, int srcCellCol) {
        double result;
        try {
            ArrayList<Double> temp = new ArrayList<Double>();
            ValueEval[] valueEvalArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ValueEval arg = valueEvalArray[n2];
                Mode.collectValues(arg, temp);
                ++n2;
            }
            double[] values = new double[temp.size()];
            int i = 0;
            while (i < values.length) {
                values[i] = (Double)temp.get(i);
                ++i;
            }
            result = Mode.evaluate(values);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static void collectValues(ValueEval arg, List<Double> temp) throws EvaluationException {
        if (arg instanceof TwoDEval) {
            TwoDEval ae = (TwoDEval)arg;
            int width = ae.getWidth();
            int height = ae.getHeight();
            int rrIx = 0;
            while (rrIx < height) {
                int rcIx = 0;
                while (rcIx < width) {
                    ValueEval ve1 = ae.getValue(rrIx, rcIx);
                    Mode.collectValue(ve1, temp, false);
                    ++rcIx;
                }
                ++rrIx;
            }
            return;
        }
        if (arg instanceof RefEval) {
            RefEval re = (RefEval)arg;
            int firstSheetIndex = re.getFirstSheetIndex();
            int lastSheetIndex = re.getLastSheetIndex();
            int sIx = firstSheetIndex;
            while (sIx <= lastSheetIndex) {
                Mode.collectValue(re.getInnerValueEval(sIx), temp, true);
                ++sIx;
            }
            return;
        }
        Mode.collectValue(arg, temp, true);
    }

    private static void collectValue(ValueEval arg, List<Double> temp, boolean mustBeNumber) throws EvaluationException {
        if (arg instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)arg);
        }
        if (arg == BlankEval.instance || arg instanceof BoolEval || arg instanceof StringEval) {
            if (mustBeNumber) {
                throw EvaluationException.invalidValue();
            }
            return;
        }
        if (arg instanceof NumberEval) {
            temp.add(((NumberEval)arg).getNumberValue());
            return;
        }
        throw new RuntimeException("Unexpected value type (" + arg.getClass().getName() + ")");
    }
}

