/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed2ArgFunction;

public class Roman
extends Fixed2ArgFunction {
    private static final int[] VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[][] REPLACEMENTS = new String[][]{{"XLV", "VL", "XCV", "VC", "CDL", "LD", "CML", "LM", "CMVC", "LMVL"}, {"CDXC", "LDXL", "CDVC", "LDVL", "CMXC", "LMXL", "XCIX", "VCIV", "XLIX", "VLIV"}, {"XLIX", "IL", "XCIX", "IC", "CDXC", "XD", "CDVC", "XDV", "CDIC", "XDIX", "LMVL", "XMV", "CMIC", "XMIX", "CMXC", "XM"}, {"XDV", "VD", "XDIX", "VDIV", "XMV", "VM", "XMIX", "VMIV"}, {"VDIV", "ID", "VMIV", "IM"}};

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval numberVE, ValueEval formVE) {
        int form;
        int number;
        try {
            ValueEval ve = OperandResolver.getSingleValue(numberVE, srcRowIndex, srcColumnIndex);
            number = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number > 3999) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number == 0) {
            return new StringEval("");
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(formVE, srcRowIndex, srcColumnIndex);
            form = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.NUM_ERROR;
        }
        if (form > 4 || form < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        String result = this.integerToRoman(number);
        if (form == 0) {
            return new StringEval(result);
        }
        return new StringEval(this.makeConcise(result, form));
    }

    /*
     * Unable to fully structure code
     */
    private String integerToRoman(int number) {
        result = new StringBuilder();
        i = 0;
        ** GOTO lbl10
        {
            number -= Roman.VALUES[i];
            result.append(Roman.ROMAN[i]);
            do {
                if (number >= Roman.VALUES[i]) continue block0;
                ++i;
lbl10:
                // 2 sources

            } while (i < 13);
        }
        return result.toString();
    }

    public String makeConcise(String input, int form) {
        String result = input;
        int i = 0;
        while (i <= form && i <= 4 && form > 0) {
            if (i != 1 || form <= 1) {
                String[] repl = REPLACEMENTS[i];
                int j = 0;
                while (j < repl.length) {
                    result = result.replace(repl[j], repl[j + 1]);
                    j += 2;
                }
            }
            ++i;
        }
        return result;
    }
}

