/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.AreaEvalBase;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

public final class Single
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Single();

    private Single() {
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        ValueEval intersect = null;
        int col = ec.getColumnIndex();
        int row = ec.getRowIndex();
        ValueEval[] valueEvalArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ValueEval val = valueEvalArray[n2];
            if (val instanceof AreaEvalBase) {
                AreaEvalBase area = (AreaEvalBase)val;
                if (area.contains(row, col)) {
                    if (intersect != null) {
                        return ErrorEval.VALUE_INVALID;
                    }
                    intersect = area.getAbsoluteValue(row, col);
                } else if (area.containsRow(row)) {
                    if (intersect != null) {
                        return ErrorEval.VALUE_INVALID;
                    }
                    intersect = area.getAbsoluteValue(row, area.getFirstColumn());
                } else if (area.containsColumn(col)) {
                    if (intersect != null) {
                        return ErrorEval.VALUE_INVALID;
                    }
                    intersect = area.getAbsoluteValue(area.getFirstRow(), col);
                }
            }
            ++n2;
        }
        if (intersect != null) {
            return intersect;
        }
        return ErrorEval.VALUE_INVALID;
    }
}

